/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.IteratorUtils;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;

public class DiscoveryJob {
    private final List<IPPollRange> m_ranges;
    private final String m_foreignSource;
    private final String m_location;
    private final double m_packetsPerSecond;

    public DiscoveryJob(List<IPPollRange> ranges, String foreignSource, String location, double packetsPerSecond) {
        this.m_ranges = (List)Preconditions.checkNotNull(ranges, (Object)"ranges argument");
        this.m_foreignSource = foreignSource;
        this.m_location = (String)Preconditions.checkNotNull((Object)location, (Object)"location argument");
        this.m_packetsPerSecond = packetsPerSecond > 0.0 ? packetsPerSecond : 1.0;
        Preconditions.checkState((boolean)this.m_ranges.stream().allMatch(range -> range.getForeignSource() == null || this.m_foreignSource.equals(range.getForeignSource())));
        Preconditions.checkState((boolean)this.m_ranges.stream().allMatch(range -> range.getLocation() == null || this.m_location.equals(range.getLocation())));
    }

    public List<IPPollRange> getRanges() {
        return this.m_ranges;
    }

    public Iterable<IPPollAddress> getAddresses() {
        ArrayList<Iterator> iters = new ArrayList<Iterator>();
        for (IPPollRange range : this.m_ranges) {
            iters.add(range.iterator());
        }
        return IteratorUtils.concatIterators(iters);
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getLocation() {
        return this.m_location;
    }

    public double getPacketsPerSecond() {
        return this.m_packetsPerSecond;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DiscoveryJob)) {
            return false;
        }
        DiscoveryJob castOther = (DiscoveryJob)other;
        return Objects.equals(this.m_ranges, castOther.m_ranges) && Objects.equals(this.m_foreignSource, castOther.m_foreignSource) && Objects.equals(this.m_location, castOther.m_location) && Objects.equals(this.m_packetsPerSecond, castOther.m_packetsPerSecond);
    }

    public int hashCode() {
        return Objects.hash(this.m_ranges, this.m_foreignSource, this.m_location, this.m_packetsPerSecond);
    }

    public String toString() {
        return String.format("DiscoveryJob[foreignSource=%s, location=%s, packetPerSecond=%s, range=%s]", this.m_foreignSource, this.m_location, this.m_packetsPerSecond, this.m_ranges);
    }
}

