/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.discovery.Discovery;
import org.opennms.netmgt.discovery.DiscoveryJob;
import org.opennms.netmgt.discovery.DiscoveryTaskExecutor;
import org.opennms.netmgt.discovery.RangeChunker;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSweepSummary;
import org.opennms.netmgt.model.discovery.IPPollRange;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscoveryTaskExecutorImpl
implements DiscoveryTaskExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryTaskExecutorImpl.class);
    @Autowired
    private RangeChunker rangeChunker;
    @Autowired
    private LocationAwarePingClient locationAwarePingClient;
    @Autowired
    private EventForwarder eventForwarder;
    private final AtomicInteger taskIdTracker = new AtomicInteger();

    @Override
    public CompletableFuture<Void> handleDiscoveryTask(DiscoveryConfiguration config) {
        final Map<String, List<DiscoveryJob>> jobsByLocation = this.rangeChunker.chunk(config);
        if (jobsByLocation.size() == 0) {
            LOG.info("No IP addresses to discover.");
            return CompletableFuture.completedFuture(null);
        }
        final int taskId = this.taskIdTracker.incrementAndGet();
        final ArrayList futures = new ArrayList(jobsByLocation.keySet().size());
        Logging.withPrefix((String)Discovery.getLoggingCategory(), (Runnable)new Runnable(){

            @Override
            public void run() {
                jobsByLocation.entrySet().stream().map(e -> DiscoveryTaskExecutorImpl.this.triggerJobsAsync((String)e.getKey(), (List)e.getValue(), taskId)).forEach(futures::add);
            }
        });
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    private CompletableFuture<Void> triggerJobsAsync(String location, List<DiscoveryJob> jobs, int taskId) {
        LOG.debug("Processing {} jobs at location {} (on task #{}).", new Object[]{jobs.size(), location, taskId});
        LinkedList<DiscoveryJob> queue = new LinkedList<DiscoveryJob>(jobs);
        AtomicInteger jobIndexTracker = new AtomicInteger();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.triggerNextJobAsync(location, queue, jobIndexTracker, jobs.size(), taskId, future);
        return future;
    }

    private void triggerNextJobAsync(String location, Queue<DiscoveryJob> jobs, AtomicInteger jobIndexTracker, int totalNumberOfJobs, int taskId, CompletableFuture<Void> future) {
        DiscoveryJob job = jobs.poll();
        if (job == null) {
            future.complete(null);
            return;
        }
        PingSweepRequestBuilder builder = this.locationAwarePingClient.sweep().withLocation(job.getLocation()).withPacketsPerSecond(job.getPacketsPerSecond());
        for (IPPollRange range : job.getRanges()) {
            try {
                InetAddress begin = InetAddress.getByAddress(range.getAddressRange().getBegin());
                InetAddress end = InetAddress.getByAddress(range.getAddressRange().getEnd());
                builder.withRange(begin, end, range.getRetries(), range.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (UnknownHostException e) {
                LOG.error("Failed to retrieve addresses from range: {}. The range will be skipped.", (Throwable)e);
            }
        }
        int jobIndex = jobIndexTracker.incrementAndGet();
        LOG.debug("Starting job {} of {} at location {} (on task #{}).", new Object[]{jobIndex, totalNumberOfJobs, location, taskId});
        builder.execute().whenComplete((summary, ex) -> Logging.withPrefix((String)Discovery.getLoggingCategory(), (Runnable)new Runnable((PingSweepSummary)summary, jobIndex, totalNumberOfJobs, location, taskId, job, (Throwable)ex, jobs, jobIndexTracker, future){
            final /* synthetic */ PingSweepSummary val$summary;
            final /* synthetic */ int val$jobIndex;
            final /* synthetic */ int val$totalNumberOfJobs;
            final /* synthetic */ String val$location;
            final /* synthetic */ int val$taskId;
            final /* synthetic */ DiscoveryJob val$job;
            final /* synthetic */ Throwable val$ex;
            final /* synthetic */ Queue val$jobs;
            final /* synthetic */ AtomicInteger val$jobIndexTracker;
            final /* synthetic */ CompletableFuture val$future;
            {
                this.val$summary = pingSweepSummary;
                this.val$jobIndex = n;
                this.val$totalNumberOfJobs = n2;
                this.val$location = string;
                this.val$taskId = n3;
                this.val$job = discoveryJob;
                this.val$ex = throwable;
                this.val$jobs = queue;
                this.val$jobIndexTracker = atomicInteger;
                this.val$future = completableFuture;
            }

            @Override
            public void run() {
                if (this.val$summary != null) {
                    LOG.debug("Job {} of {} at location {} (on task #{}) completed succesfully.", new Object[]{this.val$jobIndex, this.val$totalNumberOfJobs, this.val$location, this.val$taskId});
                    Log eventLog = DiscoveryTaskExecutorImpl.toNewSuspectEvents(this.val$job, this.val$summary);
                    if (eventLog.getEvents() != null && eventLog.getEvents().getEventCount() >= 1) {
                        DiscoveryTaskExecutorImpl.this.eventForwarder.sendNow(DiscoveryTaskExecutorImpl.toNewSuspectEvents(this.val$job, this.val$summary));
                    }
                } else {
                    LOG.error("An error occurred while processing job {} of {} at location {} (on task #{}). No newSuspect events will be generated.", new Object[]{this.val$jobIndex, this.val$totalNumberOfJobs, this.val$location, this.val$taskId, this.val$ex});
                }
                DiscoveryTaskExecutorImpl.this.triggerNextJobAsync(this.val$location, this.val$jobs, this.val$jobIndexTracker, this.val$totalNumberOfJobs, this.val$taskId, this.val$future);
            }
        }));
    }

    protected static Log toNewSuspectEvents(DiscoveryJob job, PingSweepSummary summary) {
        Log eventLog = new Log();
        for (Map.Entry entry : summary.getResponses().entrySet()) {
            EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "Discovery");
            eb.setInterface((InetAddress)entry.getKey());
            eb.addParam("RTT", ((Double)entry.getValue()).doubleValue());
            if (job.getForeignSource() != null) {
                eb.addParam("foreignSource", job.getForeignSource());
            }
            if (job.getLocation() != null) {
                eb.addParam("location", job.getLocation());
            }
            eventLog.addEvent(eb.getEvent());
        }
        return eventLog;
    }

    public void setRangeChunker(RangeChunker rangeChunker) {
        this.rangeChunker = rangeChunker;
    }

    public void setLocationAwarePingClient(LocationAwarePingClient locationAwarePingClient) {
        this.locationAwarePingClient = locationAwarePingClient;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }
}

