/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opennms.core.network.IPAddress;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.discovery.DiscoveryJob;
import org.opennms.netmgt.discovery.IpAddressFilter;
import org.opennms.netmgt.model.discovery.IPPollRange;

public class RangeChunker {
    private final IpAddressFilter ipAddressFilter;

    public RangeChunker(IpAddressFilter ipAddressFilter) {
        this.ipAddressFilter = Objects.requireNonNull(ipAddressFilter);
    }

    public Map<String, List<DiscoveryJob>> chunk(DiscoveryConfiguration config) {
        int chunkSize = config.getChunkSize().orElse(100);
        double packetsPerSecond = config.getPacketsPerSecond().orElse(1.0);
        String foreignSourceFromConfig = config.getForeignSource().isPresent() ? ((String)config.getForeignSource().get()).trim() : null;
        String locationFromConfig = config.getLocation().map(l -> {
            String trimmed = l.trim();
            if ("".equals(trimmed)) {
                return null;
            }
            return trimmed;
        }).orElse("Default");
        DiscoveryConfigFactory configFactory = new DiscoveryConfigFactory(config);
        AtomicReference previousRange = new AtomicReference();
        return StreamSupport.stream(configFactory.getConfiguredAddresses().spliterator(), false).filter(address -> this.ipAddressFilter.matches(address.getLocation(), address.getAddress())).map(address -> new IPPollRange(address.getForeignSource() == null ? foreignSourceFromConfig : address.getForeignSource(), address.getLocation() == null ? locationFromConfig : address.getLocation(), address.getAddress(), address.getAddress(), address.getTimeout(), address.getRetries())).collect(Collectors.groupingBy(range -> new ForeignSourceLocationKey(range.getForeignSource() == null ? foreignSourceFromConfig : range.getForeignSource(), range.getLocation() == null ? locationFromConfig : range.getLocation()), LinkedHashMap::new, Collectors.toList())).entrySet().stream().flatMap(entry -> Lists.partition((List)((List)entry.getValue()), (int)chunkSize).stream().map(ranges -> {
            DiscoveryJob retval = new DiscoveryJob(ranges.stream().map(address -> {
                if (RangeChunker.isConsecutive((IPPollRange)previousRange.get(), address)) {
                    ((IPPollRange)previousRange.get()).getAddressRange().incrementEnd();
                    return null;
                }
                previousRange.set(address);
                return address;
            }).filter(Objects::nonNull).collect(Collectors.toList()), ((ForeignSourceLocationKey)entry.getKey()).getForeignSource(), ((ForeignSourceLocationKey)entry.getKey()).getLocation(), packetsPerSecond);
            previousRange.set(null);
            return retval;
        }).collect(Collectors.toList()).stream()).collect(Collectors.groupingBy(job -> job.getLocation(), LinkedHashMap::new, Collectors.toList()));
    }

    protected static boolean isConsecutive(IPPollRange range, IPPollRange address) {
        Preconditions.checkState((boolean)BigInteger.ONE.equals(address.getAddressRange().size()));
        return range != null && new IPAddress(range.getAddressRange().getEnd()).isPredecessorOf(new IPAddress(address.getAddressRange().getEnd())) && Objects.equals(range.getForeignSource(), address.getForeignSource()) && Objects.equals(range.getLocation(), address.getLocation()) && range.getRetries() == address.getRetries() && range.getTimeout() == address.getTimeout();
    }

    private static class ForeignSourceLocationKey {
        private final String m_location;
        private final String m_foreignSource;

        public ForeignSourceLocationKey(String foreignSource, String location) {
            this.m_location = location;
            this.m_foreignSource = foreignSource;
        }

        public String getForeignSource() {
            return this.m_foreignSource;
        }

        public String getLocation() {
            return this.m_location;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ForeignSourceLocationKey other = (ForeignSourceLocationKey)obj;
            return Objects.equals(this.m_foreignSource, other.m_foreignSource) && Objects.equals(this.m_location, other.m_location);
        }

        public int hashCode() {
            return Objects.hash(this.m_foreignSource, this.m_location);
        }
    }
}

