/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery.actors;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.util.Map;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.discovery.messages.DiscoveryResults;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventWriter {
    private static final Logger LOG = LoggerFactory.getLogger(EventWriter.class);
    private final EventForwarder m_ipc_manager;

    public EventWriter(EventForwarder ipcManager) {
        this.m_ipc_manager = (EventForwarder)Preconditions.checkNotNull((Object)ipcManager, (Object)"ipcManager argument");
    }

    public void sendEvents(DiscoveryResults results) {
        results.getResponses().entrySet().forEach(e -> this.sendNewSuspectEvent((InetAddress)e.getKey(), (Long)e.getValue(), (Map<String, Optional<String>>)ImmutableMap.of((Object)"foreignSource", Optional.ofNullable(results.getForeignSource()), (Object)"location", Optional.ofNullable(results.getLocation()))));
    }

    private void sendNewSuspectEvent(InetAddress address, Long rtt, Map<String, Optional<String>> eventParameters) {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "OpenNMS.Discovery");
        eb.setInterface(address);
        eb.setHost(InetAddressUtils.getLocalHostName());
        eb.addParam("RTT", rtt.longValue());
        eventParameters.entrySet().forEach(eachEntry -> ((Optional)eachEntry.getValue()).ifPresent(v -> eb.addParam((String)eachEntry.getKey(), v)));
        try {
            this.m_ipc_manager.sendNow(eb.getEvent());
            LOG.debug("Sent event: {}", (Object)"uei.opennms.org/internal/discovery/newSuspect");
        }
        catch (Throwable t) {
            LOG.warn("run: unexpected throwable exception caught during send to middleware", t);
        }
    }
}

