/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.discovery.IpAddressFilter;

public class UnmanagedInterfaceFilter
implements IpAddressFilter {
    private Set<LocationIpAddressKey> m_managedAddresses = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedAddress(String location, String address) {
        Set<LocationIpAddressKey> set = this.m_managedAddresses;
        synchronized (set) {
            this.m_managedAddresses.add(new LocationIpAddressKey(location, address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedAddress(String location, String address) {
        Set<LocationIpAddressKey> set = this.m_managedAddresses;
        synchronized (set) {
            this.m_managedAddresses.remove(new LocationIpAddressKey(location, address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Set<LocationIpAddressKey> set = this.m_managedAddresses;
        synchronized (set) {
            return this.m_managedAddresses.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagedAddresses(Set<LocationIpAddressKey> addresses) {
        Set<LocationIpAddressKey> set = this.m_managedAddresses;
        synchronized (set) {
            this.m_managedAddresses.clear();
            this.m_managedAddresses.addAll(addresses);
        }
    }

    @Override
    public boolean matches(String location, InetAddress address) {
        return this.matches(location, InetAddressUtils.str((InetAddress)address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(String location, String address) {
        Set<LocationIpAddressKey> set = this.m_managedAddresses;
        synchronized (set) {
            return !this.m_managedAddresses.contains(new LocationIpAddressKey(location, address));
        }
    }

    public static class LocationIpAddressKey {
        private final String m_location;
        private final String m_ipAddress;

        public LocationIpAddressKey(String location, String ipAddress) {
            this.m_location = location;
            this.m_ipAddress = ipAddress;
        }

        public String getIpAddress() {
            return this.m_ipAddress;
        }

        public String getLocation() {
            return this.m_location;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LocationIpAddressKey key = (LocationIpAddressKey)obj;
            return new EqualsBuilder().append((Object)this.m_ipAddress, (Object)key.getIpAddress()).append((Object)this.m_location, (Object)key.getLocation()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.m_ipAddress).append((Object)this.m_location).toHashCode();
        }
    }
}

