/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.discovery.DiscoveryPingResponseCallback;
import org.opennms.netmgt.discovery.UnmanagedInterfaceFilter;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;

@EventListener(name="OpenNMS.Discovery", logPrefix="discovery")
public class Discovery
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Discovery.class);
    private static final DiscoveryPingResponseCallback cb = new DiscoveryPingResponseCallback();
    private static final String LOG4J_CATEGORY = "discovery";
    private static final String ALL_IP_ADDRS_SQL = "SELECT DISTINCT ipAddr FROM ipInterface WHERE isManaged <> 'D'";
    private DiscoveryConfigFactory m_discoveryFactory;
    private EventForwarder m_eventForwarder;
    private UnmanagedInterfaceFilter m_interfaceFilter = null;
    @Autowired
    @Qualifier(value="discoveryCamelContext")
    private CamelContext m_camelContext;

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setDiscoveryFactory(DiscoveryConfigFactory discoveryFactory) {
        this.m_discoveryFactory = discoveryFactory;
    }

    public DiscoveryConfigFactory getDiscoveryFactory() {
        return this.m_discoveryFactory;
    }

    public void setUnmanagedInterfaceFilter(UnmanagedInterfaceFilter filter) {
        this.m_interfaceFilter = filter;
    }

    public UnmanagedInterfaceFilter getUnmanagedInterfaceFilter() {
        return this.m_interfaceFilter;
    }

    public Discovery() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() throws IllegalStateException {
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        Assert.state((this.m_discoveryFactory != null ? 1 : 0) != 0, (String)"must set the Discovery Factory property");
        cb.setDiscoveryFactory(this.m_discoveryFactory);
        try {
            LOG.debug("Initializing configuration...");
            this.m_discoveryFactory.reload();
            LOG.debug("Configuration initialized.  Init the factory...");
            EventIpcManagerFactory.init();
            LOG.debug("Factory init'd.");
        }
        catch (Throwable e) {
            LOG.debug("onInit: initialization failed", e);
            throw new IllegalStateException("Could not initialize discovery configuration.", e);
        }
    }

    protected void onStart() {
        this.syncAlreadyDiscovered();
        try {
            this.m_camelContext.start();
        }
        catch (Exception e) {
            LOG.error("Discovery startup failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void onStop() {
        try {
            this.m_camelContext.stop();
        }
        catch (Exception e) {
            LOG.error("Discovery shutdown failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void onPause() {
        try {
            this.m_camelContext.stop();
        }
        catch (Exception e) {
            LOG.error("Discovery pause failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void onResume() {
        try {
            this.m_camelContext.start();
        }
        catch (Exception e) {
            LOG.error("Discovery resume failed: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncAlreadyDiscovered() {
        Set<String> newAlreadyDiscovered = Collections.synchronizedSet(new HashSet());
        Connection conn = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(ALL_IP_ADDRS_SQL);
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs != null) {
                while (rs.next()) {
                    newAlreadyDiscovered.add(rs.getString(1));
                }
            } else {
                LOG.warn("Got null ResultSet from query for all IP addresses");
            }
            this.m_interfaceFilter.setManagedAddresses(newAlreadyDiscovered);
        }
        catch (SQLException sqle) {
            LOG.warn("Caught SQLException while trying to query for all IP addresses: {}", (Object)sqle.getMessage());
        }
        finally {
            d.cleanUp();
        }
        LOG.info("syncAlreadyDiscovered initialized list of managed IP addresses with {} members", (Object)this.m_interfaceFilter.size());
    }

    @EventHandler(uei="uei.opennms.org/internal/discoveryConfigChange")
    public void handleDiscoveryConfigurationChanged(Event event) {
        LOG.info("handleDiscoveryConfigurationChanged: handling message that a change to configuration happened...");
        this.reloadAndReStart();
    }

    private void reloadAndReStart() {
        EventBuilder ebldr = null;
        try {
            this.m_discoveryFactory.reload();
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            this.stop();
            this.start();
        }
        catch (MarshalException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (ValidationException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (IOException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Discovery");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        this.m_eventForwarder.sendNow(ebldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void reloadDaemonConfig(Event e) {
        LOG.info("reloadDaemonConfig: processing reload daemon event...");
        if (this.isReloadConfigEventTarget(e)) {
            this.reloadAndReStart();
        }
        LOG.info("reloadDaemonConfig: reload daemon event processed.");
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Discovery".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: discovery was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    public void handleInterfaceDeleted(Event event) {
        if (event.getInterface() != null) {
            String iface = event.getInterface();
            this.m_interfaceFilter.removeManagedAddress(iface);
            LOG.debug("Removed {} from known interface list", (Object)iface);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discResume")
    public void handleDiscoveryResume(Event event) {
        try {
            this.resume();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discPause")
    public void handleDiscoveryPause(Event event) {
        try {
            this.pause();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedInterface")
    public void handleNodeGainedInterface(Event event) {
        String iface = event.getInterface();
        this.m_interfaceFilter.addManagedAddress(iface);
        LOG.debug("Added interface {} as discovered", (Object)iface);
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

