/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery.actors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.discovery.IpAddressFilter;
import org.opennms.netmgt.discovery.messages.DiscoveryJob;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;

public class RangeChunker {
    public static final int DEFAULT_CHUNK_SIZE = 100;
    private final int m_defaultChunkSize;
    private IpAddressFilter m_ipAddressFilter;

    public RangeChunker() {
        this(100);
    }

    public RangeChunker(int defaultChunkSize) {
        this.m_defaultChunkSize = defaultChunkSize;
    }

    public void setIpAddressFilter(IpAddressFilter ipAddressFilter) {
        this.m_ipAddressFilter = ipAddressFilter;
    }

    public List<DiscoveryJob> chunk(DiscoveryConfiguration config) {
        int chunkSize = config.getChunkSize() > 0 ? config.getChunkSize() : this.m_defaultChunkSize;
        DiscoveryConfigFactory configFactory = new DiscoveryConfigFactory(config);
        ArrayList<IPPollRange> ranges = new ArrayList<IPPollRange>();
        for (IPPollAddress address : configFactory.getConfiguredAddresses()) {
            if (this.m_ipAddressFilter != null && !this.m_ipAddressFilter.matches(address.getAddress())) continue;
            IPPollRange range = new IPPollRange(address.getAddress(), address.getAddress(), address.getTimeout(), address.getRetries());
            ranges.add(range);
        }
        String foreignSource = config.getForeignSource() == null || "".equals(config.getForeignSource().trim()) ? "default" : config.getForeignSource().trim();
        String location = config.getLocation() == null || "".equals(config.getLocation().trim()) ? "localhost" : config.getLocation().trim();
        return Lists.partition(ranges, (int)chunkSize).stream().map(r -> new DiscoveryJob(new ArrayList<IPPollRange>((Collection<IPPollRange>)r), foreignSource, location)).collect(Collectors.toList());
    }
}

