/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.utils.IteratorIterator;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;

public class DiscoveryJob
implements Serializable {
    private static final long serialVersionUID = 3750201609939695254L;
    private final List<IPPollRange> m_ranges;
    private final String m_foreignSource;
    private final String m_location;

    public DiscoveryJob(List<IPPollRange> ranges, String foreignSource, String location) {
        this.m_ranges = (List)Preconditions.checkNotNull(ranges, (Object)"ranges argument");
        this.m_foreignSource = (String)Preconditions.checkNotNull((Object)foreignSource, (Object)"foreignSource argument");
        this.m_location = (String)Preconditions.checkNotNull((Object)location, (Object)"location argument");
    }

    public Iterable<IPPollAddress> getAddresses() {
        ArrayList<Iterator> iters = new ArrayList<Iterator>();
        for (IPPollRange range : this.m_ranges) {
            iters.add(range.iterator());
        }
        return new IteratorIterator(iters);
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getLocation() {
        return this.m_location;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryJob other = (DiscoveryJob)obj;
        return Objects.equal(this.m_ranges, other.m_ranges) && Objects.equal((Object)this.m_foreignSource, (Object)other.m_foreignSource) && Objects.equal((Object)this.m_location, (Object)other.m_location);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.m_ranges, this.m_foreignSource, this.m_location});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("foreignSource", (Object)this.m_foreignSource).add("location", (Object)this.m_location).add("ranges", this.m_ranges).toString();
    }
}

