/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.graph.status;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.apilayer.graph.status.LegacyEdgeStatusProviderManager;
import org.opennms.features.apilayer.utils.InterfaceMapper;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertex;
import org.opennms.integration.api.v1.graph.status.LegacyStatusProvider;
import org.opennms.integration.api.v1.graph.status.StatusInfo;
import org.opennms.netmgt.graph.provider.topology.LegacyVertex;
import org.opennms.netmgt.model.OnmsSeverity;
import org.osgi.framework.BundleContext;

public class LegacyVertexStatusProviderManager
extends InterfaceMapper<LegacyStatusProvider, StatusProvider> {
    public LegacyVertexStatusProviderManager(BundleContext bundleContext) {
        super(StatusProvider.class, bundleContext);
    }

    @Override
    public StatusProvider map(final LegacyStatusProvider extension) {
        return new StatusProvider(){

            public String getNamespace() {
                return null;
            }

            public boolean contributesTo(String namespace) {
                return extension.canCalculate(namespace);
            }

            public Map<? extends VertexRef, ? extends Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
                HashMap statusMap = new HashMap();
                vertices.forEach(vertexRef -> {
                    Vertex vertex = graph.getVertex(vertexRef, criteria);
                    if (vertex instanceof LegacyVertex) {
                        LegacyVertex legacyVertex = (LegacyVertex)vertex;
                        ImmutableVertex apiVertex = ((ImmutableVertex.Builder)ImmutableVertex.newBuilder((String)legacyVertex.getNamespace(), (String)legacyVertex.getId()).properties(legacyVertex.getProperties())).build();
                        StatusInfo apiStatus = extension.calculateStatus((org.opennms.integration.api.v1.graph.Vertex)apiVertex);
                        Status status = LegacyEdgeStatusProviderManager.convert(apiStatus);
                        statusMap.put(vertexRef, status);
                    } else {
                        statusMap.put(vertexRef, new DefaultStatus(OnmsSeverity.INDETERMINATE.getLabel(), 0L));
                    }
                });
                return statusMap;
            }
        };
    }
}

