/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.pollers;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.integration.api.v1.pollers.PollerRequest;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.ServicePoller;
import org.opennms.integration.api.v1.pollers.ServicePollerFactory;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;

public class ServicePollerImpl<T extends ServicePoller>
implements ServiceMonitor {
    private ServicePollerFactory<T> servicePollerFactory;

    public ServicePollerImpl(ServicePollerFactory servicePollerFactory) {
        this.servicePollerFactory = servicePollerFactory;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollerResult pollStatus;
        Map<String, String> attributes = this.getAttributes(parameters);
        PollerRequestImpl monitoredService = new PollerRequestImpl(svc, attributes);
        ServicePoller servicePoller = this.servicePollerFactory.createPoller();
        CompletableFuture future = servicePoller.poll((PollerRequest)monitoredService);
        try {
            pollStatus = (PollerResult)future.get();
            switch (pollStatus.getStatus()) {
                case Up: {
                    return PollStatus.up();
                }
                case Down: {
                    return PollStatus.down((String)pollStatus.getReason());
                }
                case UnResponsive: {
                    return PollStatus.unresponsive((String)pollStatus.getReason());
                }
                case Unknown: {
                    return PollStatus.unknown((String)pollStatus.getReason());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return PollStatus.down((String)e.getMessage());
        }
        return PollStatus.unknown((String)pollStatus.getReason());
    }

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        HashMap<String, Object> runTimeAttributes = new HashMap<String, Object>();
        Map attributes = this.servicePollerFactory.getRuntimeAttributes((PollerRequest)new PollerRequestImpl(svc, this.getAttributes(parameters)));
        attributes.forEach(runTimeAttributes::put);
        return runTimeAttributes;
    }

    private Map<String, String> getAttributes(Map<String, Object> parameters) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        parameters.forEach((parameter, value) -> {
            if (value instanceof String) {
                attributes.put((String)parameter, (String)value);
            }
        });
        return attributes;
    }

    public String getEffectiveLocation(String location) {
        return null;
    }

    protected class PollerRequestImpl
    implements PollerRequest {
        private MonitoredService monitoredService;
        private Map<String, String> attributes;

        private PollerRequestImpl(MonitoredService svc, Map<String, String> attributes) {
            this.monitoredService = svc;
            this.attributes = attributes;
        }

        public String getServiceName() {
            return this.monitoredService.getSvcName();
        }

        public InetAddress getAddress() {
            return this.monitoredService.getAddress();
        }

        public int getNodeId() {
            return this.monitoredService.getNodeId();
        }

        public Map<String, String> getPollerAttributes() {
            return this.attributes;
        }
    }
}

