/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.integration.api.v1.runtime.Version;

public class VersionBean
implements Version {
    private static final Pattern versionPattern = Pattern.compile("^(\\d+).(\\d+)\\.(\\d+)(?<snapshot>.+)?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isSnapshot;

    public VersionBean(String version) {
        Matcher m = versionPattern.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Unsupported version string: " + version);
        }
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
        this.patch = Integer.parseInt(m.group(3));
        this.isSnapshot = m.group("snapshot") != null;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public int compareTo(Version v) {
        if (v == null) {
            return -1;
        }
        return Comparator.comparingInt(Version::getMajor).thenComparingInt(Version::getMinor).thenComparingInt(Version::getPatch).compare(this, v);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionBean that = (VersionBean)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.isSnapshot == that.isSnapshot;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.isSnapshot);
    }

    public String toString() {
        return String.format("v%d.%d.%d%s", this.major, this.minor, this.patch, this.isSnapshot ? "-SNAPSHOT" : "");
    }
}

