/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.ObjectNotFoundException;
import org.mapstruct.factory.Mappers;
import org.opennms.features.apilayer.model.mappers.AlarmFeedbackMapper;
import org.opennms.features.apilayer.model.mappers.DatabaseEventMapper;
import org.opennms.features.apilayer.model.mappers.InMemoryEventMapper;
import org.opennms.features.apilayer.model.mappers.NodeMapper;
import org.opennms.features.apilayer.model.mappers.SnmpInterfaceMapper;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.TopologyProtocol;
import org.opennms.integration.api.v1.model.immutables.ImmutableAlarm;
import org.opennms.integration.api.v1.model.immutables.ImmutableNode;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMappers {
    private static final Logger LOG = LoggerFactory.getLogger(ModelMappers.class);
    private static final InMemoryEventMapper inMemoryEventMapper = (InMemoryEventMapper)Mappers.getMapper(InMemoryEventMapper.class);
    private static final DatabaseEventMapper databaseEventMapper = (DatabaseEventMapper)Mappers.getMapper(DatabaseEventMapper.class);
    private static final NodeMapper nodeMapper = (NodeMapper)Mappers.getMapper(NodeMapper.class);
    private static final SnmpInterfaceMapper snmpInterfaceMapper = (SnmpInterfaceMapper)Mappers.getMapper(SnmpInterfaceMapper.class);
    private static final AlarmFeedbackMapper alarmFeedbackMapper = (AlarmFeedbackMapper)Mappers.getMapper(AlarmFeedbackMapper.class);
    private static final String nodeCacheSpec = System.getProperty("org.opennms.features.apilayer.mapping.nodeCacheSpec", "maximumSize=10000,expireAfterWrite=15m");
    private static final LoadingCache<NodeKey, Node> nodeCache = CacheBuilder.from((String)nodeCacheSpec).build((CacheLoader)new CacheLoader<NodeKey, Node>(){

        public Node load(NodeKey nodeKey) {
            return nodeMapper.map(nodeKey.node);
        }
    });

    public static Alarm toAlarm(OnmsAlarm alarm) {
        if (alarm == null) {
            return null;
        }
        ImmutableAlarm.Builder builder = ImmutableAlarm.newBuilder().setReductionKey(alarm.getReductionKey()).setId(alarm.getId()).setManagedObjectInstance(alarm.getManagedObjectInstance()).setManagedObjectType(alarm.getManagedObjectType()).setAttributes(alarm.getDetails()).setSeverity(ModelMappers.toSeverity(alarm.getSeverity())).setRelatedAlarms(alarm.getRelatedAlarms().stream().map(ModelMappers::toAlarm).collect(Collectors.toList())).setLogMessage(alarm.getLogMsg()).setDescription(alarm.getDescription()).setLastEventTime(alarm.getLastEventTime()).setFirstEventTime(alarm.getFirstEventTime());
        try {
            if (alarm.getNode() != null) {
                builder.setNode((Node)nodeCache.get((Object)new NodeKey(alarm.getNode())));
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load node for alarm with id: {}", (Object)alarm.getId(), (Object)e);
        }
        try {
            builder.setLastEvent(ModelMappers.toEvent(alarm.getLastEvent()));
        }
        catch (RuntimeException e) {
            if (ObjectNotFoundException.class.getCanonicalName().equals(e.getClass().getCanonicalName())) {
                LOG.debug("The last event for alarm with id {} was deleted before we could perform the mapping. Last event will be null.", (Object)alarm.getId());
            }
            throw e;
        }
        return builder.build();
    }

    public static InMemoryEvent toEvent(Event event) {
        return event == null ? null : inMemoryEventMapper.map(event);
    }

    public static Event toEvent(InMemoryEvent event) {
        EventBuilder builder = new EventBuilder(event.getUei(), event.getSource());
        if (event.getNodeId() != null) {
            builder.setNodeid(event.getNodeId().longValue());
        }
        if (event.getSeverity() != null) {
            builder.setSeverity(OnmsSeverity.get((int)event.getSeverity().getId()).getLabel());
        }
        for (EventParameter p : event.getParameters()) {
            builder.setParam(p.getName(), p.getValue());
        }
        return builder.getEvent();
    }

    public static DatabaseEvent toEvent(OnmsEvent event) {
        return event == null ? null : databaseEventMapper.map(event);
    }

    public static Node toNode(OnmsNode node) {
        if (node == null) {
            return null;
        }
        ImmutableNode apiNode = nodeMapper.map(node);
        nodeCache.put((Object)new NodeKey(node.getId()), (Object)apiNode);
        return apiNode;
    }

    public static SnmpInterface toSnmpInterface(OnmsSnmpInterface snmpInterface) {
        return snmpInterface == null ? null : snmpInterfaceMapper.map(snmpInterface);
    }

    public static Severity toSeverity(OnmsSeverity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case CLEARED: {
                return Severity.CLEARED;
            }
            case NORMAL: {
                return Severity.NORMAL;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case MINOR: {
                return Severity.MINOR;
            }
            case MAJOR: {
                return Severity.MAJOR;
            }
            case CRITICAL: {
                return Severity.CRITICAL;
            }
        }
        return Severity.INDETERMINATE;
    }

    public static org.opennms.integration.api.v1.model.AlarmFeedback toFeedback(AlarmFeedback feedback) {
        return feedback == null ? null : alarmFeedbackMapper.map(feedback);
    }

    public static AlarmFeedback fromFeedback(org.opennms.integration.api.v1.model.AlarmFeedback feedback) {
        return feedback == null ? null : AlarmFeedback.newBuilder().withTimestamp(feedback.getTimestamp().longValue()).withAlarmKey(feedback.getAlarmKey()).withFeedbackType(AlarmFeedback.FeedbackType.valueOfOrUnknown((String)feedback.getFeedbackType().toString())).withReason(feedback.getReason()).withSituationFingerprint(feedback.getSituationFingerprint()).withSituationKey(feedback.getSituationKey()).withUser(feedback.getUser()).build();
    }

    public static OnmsTopologyProtocol toOnmsTopologyProtocol(TopologyProtocol protocol) {
        return OnmsTopologyProtocol.create((String)protocol.name());
    }

    public static TopologyProtocol toTopologyProtocol(OnmsTopologyProtocol protocol) {
        return TopologyProtocol.valueOf((String)protocol.getId());
    }

    private static final class NodeKey {
        private final OnmsNode node;
        private final int nodeId;

        public NodeKey(OnmsNode node) {
            this.node = node;
            this.nodeId = node.getId();
        }

        public NodeKey(int nodeId) {
            this.node = null;
            this.nodeId = nodeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeKey)) {
                return false;
            }
            NodeKey nodeKey = (NodeKey)o;
            return this.nodeId == nodeKey.nodeId;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId);
        }
    }
}

