/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterfaceMapper<S, T> {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceMapper.class);
    protected final Class<T> clazz;
    protected final BundleContext bundleContext;
    protected final Map<S, ServiceRegistration<T>> extServiceRegistrationMap = new LinkedHashMap<S, ServiceRegistration<T>>();

    public InterfaceMapper(Class<T> clazz, BundleContext bundleContext) {
        this.clazz = Objects.requireNonNull(clazz);
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public synchronized void onBind(S extension, Map properties) {
        LOG.debug("bind called with {}: {}", extension, (Object)properties);
        if (extension != null) {
            this.extServiceRegistrationMap.computeIfAbsent(extension, ext -> {
                T mappedExt = this.map(ext);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                this.getServiceProperties(extension).forEach(props::put);
                props.put("registration.export", Boolean.TRUE.toString());
                props.putAll(this.getServiceProperties(extension));
                return this.bundleContext.registerService(this.clazz, mappedExt, props);
            });
        }
    }

    public synchronized void onUnbind(S extension, Map properties) {
        ServiceRegistration<T> registration;
        LOG.debug("unbind called with {}: {}", extension, (Object)properties);
        if (extension != null && (registration = this.extServiceRegistrationMap.remove(extension)) != null) {
            registration.unregister();
        }
    }

    public Map<String, Object> getServiceProperties(S extension) {
        return Collections.emptyMap();
    }

    public abstract T map(S var1);
}

