/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.topology;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.utils.EdgeMapper;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.dao.EdgeDao;
import org.opennms.integration.api.v1.model.TopologyEdge;
import org.opennms.integration.api.v1.model.TopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;

public class EdgeDaoImpl
implements EdgeDao {
    private final OnmsTopologyDao onmsTopologyDao;
    private final EdgeMapper edgeMapper;

    public EdgeDaoImpl(OnmsTopologyDao onmsTopologyDao, EdgeMapper edgeMapper) {
        this.onmsTopologyDao = Objects.requireNonNull(onmsTopologyDao);
        this.edgeMapper = Objects.requireNonNull(edgeMapper);
    }

    private static boolean includeAll(OnmsTopologyProtocol protocol) {
        return true;
    }

    private long getEdgeCount(Predicate<OnmsTopologyProtocol> filter) {
        return this.onmsTopologyDao.getTopologies().entrySet().stream().filter(entry -> filter.test((OnmsTopologyProtocol)entry.getKey())).mapToLong(entry -> ((OnmsTopology)entry.getValue()).getEdges().size()).sum();
    }

    private Set<TopologyEdge> getEdges(Predicate<OnmsTopologyProtocol> filter) {
        HashSet<TopologyEdge> currentEdges = new HashSet<TopologyEdge>();
        this.onmsTopologyDao.getTopologies().entrySet().stream().filter(entry -> filter.test((OnmsTopologyProtocol)entry.getKey())).forEach(entry -> ((OnmsTopology)entry.getValue()).getEdges().stream().map(edge -> this.edgeMapper.toEdge((OnmsTopologyProtocol)entry.getKey(), (OnmsTopologyEdge)edge)).forEach(currentEdges::add));
        return currentEdges;
    }

    public long getEdgeCount() {
        return this.getEdgeCount(EdgeDaoImpl::includeAll);
    }

    public long getEdgeCount(TopologyProtocol protocol) {
        if (protocol == TopologyProtocol.ALL) {
            return this.getEdgeCount();
        }
        return this.getEdgeCount((OnmsTopologyProtocol p) -> p.equals((Object)ModelMappers.toOnmsTopologyProtocol(protocol)));
    }

    public Set<TopologyEdge> getEdges() {
        return this.getEdges(EdgeDaoImpl::includeAll);
    }

    public Set<TopologyEdge> getEdges(TopologyProtocol protocol) {
        if (protocol == TopologyProtocol.ALL) {
            return this.getEdges();
        }
        return this.getEdges((OnmsTopologyProtocol p) -> p.equals((Object)ModelMappers.toOnmsTopologyProtocol(protocol)));
    }

    public Set<TopologyProtocol> getProtocols() {
        return this.onmsTopologyDao.getSupportedProtocols().stream().map(ModelMappers::toTopologyProtocol).collect(Collectors.toSet());
    }
}

