/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.integration.api.v1.config.thresholding.Basethresholddef;
import org.opennms.integration.api.v1.config.thresholding.Expression;
import org.opennms.integration.api.v1.config.thresholding.FilterOperator;
import org.opennms.integration.api.v1.config.thresholding.GroupDefinition;
import org.opennms.integration.api.v1.config.thresholding.Threshold;
import org.opennms.integration.api.v1.config.thresholding.ThresholdingConfigExtension;
import org.opennms.netmgt.config.dao.thresholding.api.WriteableThresholdingDao;
import org.opennms.netmgt.config.threshd.Group;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingConfigExtensionManager
extends ConfigExtensionManager<ThresholdingConfigExtension, ThresholdingConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingConfigExtensionManager.class);
    private final WriteableThresholdingDao thresholdingDao;
    private final ThresholdingService thresholdingService;

    public ThresholdingConfigExtensionManager(WriteableThresholdingDao thresholdingDao, ThresholdingService thresholdingService) {
        super(ThresholdingConfig.class, new ThresholdingConfig());
        this.thresholdingDao = Objects.requireNonNull(thresholdingDao);
        this.thresholdingService = Objects.requireNonNull(thresholdingService);
        LOG.debug("ThreshdConfigurationExtensionManager initialized.");
    }

    @Override
    protected ThresholdingConfig getConfigForExtensions(Set<ThresholdingConfigExtension> extensions) {
        ThresholdingConfig mergedConfig = new ThresholdingConfig();
        mergedConfig.setGroups(extensions.stream().flatMap(e -> e.getGroupDefinitions().stream()).map(ThresholdingConfigExtensionManager::toGroup).collect(Collectors.toList()));
        return mergedConfig;
    }

    @Override
    protected void triggerReload() {
        LOG.debug("Thresholding configuration changed. Triggering a reload.");
        this.thresholdingDao.onConfigChanged();
        try {
            this.thresholdingService.getThresholdingSetPersister().reinitializeThresholdingSets();
            LOG.debug("Requested a reinitialize of the thresholding set persister");
        }
        catch (ServiceException e) {
            LOG.debug("Failed to reinitialize the thresholding set persister", (Throwable)e);
        }
    }

    private static Group toGroup(GroupDefinition groupDefinition) {
        Group group = new Group();
        group.setName(groupDefinition.getName());
        group.setRrdRepository(groupDefinition.getRrdRepository());
        group.setExpressions(groupDefinition.getExpressions().stream().map(ThresholdingConfigExtensionManager::toExpression).collect(Collectors.toList()));
        group.setThresholds(groupDefinition.getThresholds().stream().map(ThresholdingConfigExtensionManager::toThreshold).collect(Collectors.toList()));
        return group;
    }

    private static org.opennms.netmgt.config.threshd.Expression toExpression(Expression expression) {
        org.opennms.netmgt.config.threshd.Expression newExpression = new org.opennms.netmgt.config.threshd.Expression();
        newExpression.setExpression(expression.getExpression());
        ThresholdingConfigExtensionManager.setBaseThresholddef((org.opennms.netmgt.config.threshd.Basethresholddef)newExpression, (Basethresholddef)expression);
        return newExpression;
    }

    private static org.opennms.netmgt.config.threshd.Threshold toThreshold(Threshold threshold) {
        org.opennms.netmgt.config.threshd.Threshold newThreshold = new org.opennms.netmgt.config.threshd.Threshold();
        newThreshold.setDsName(threshold.getDsName());
        ThresholdingConfigExtensionManager.setBaseThresholddef((org.opennms.netmgt.config.threshd.Basethresholddef)newThreshold, (Basethresholddef)threshold);
        return newThreshold;
    }

    private static void setBaseThresholddef(org.opennms.netmgt.config.threshd.Basethresholddef to, Basethresholddef from) {
        from.getDescription().ifPresent(arg_0 -> ((org.opennms.netmgt.config.threshd.Basethresholddef)to).setDescription(arg_0));
        from.getDsLabel().ifPresent(arg_0 -> ((org.opennms.netmgt.config.threshd.Basethresholddef)to).setDsLabel(arg_0));
        to.setDsType(from.getDsType());
        to.setFilterOperator(ThresholdingConfigExtensionManager.toFilterOperator(from.getFilterOperator()));
        to.setRearm(from.getRearm());
        from.getRearmedUEI().ifPresent(arg_0 -> ((org.opennms.netmgt.config.threshd.Basethresholddef)to).setRearmedUEI(arg_0));
        to.setRelaxed(from.getRelaxed());
        to.setResourceFilters(from.getResourceFilters().stream().map(ThresholdingConfigExtensionManager::toResourceFilter).collect(Collectors.toList()));
        to.setTrigger(from.getTrigger());
        from.getTriggeredUEI().ifPresent(arg_0 -> ((org.opennms.netmgt.config.threshd.Basethresholddef)to).setTriggeredUEI(arg_0));
        to.setType(ThresholdingConfigExtensionManager.toThresholdType(from.getType()));
        to.setValue(from.getValue());
    }

    private static org.opennms.netmgt.config.threshd.FilterOperator toFilterOperator(FilterOperator filterOperator) {
        return org.opennms.netmgt.config.threshd.FilterOperator.valueOf((String)filterOperator.name());
    }

    private static ThresholdType toThresholdType(org.opennms.integration.api.v1.config.thresholding.ThresholdType thresholdType) {
        return ThresholdType.valueOf((String)thresholdType.name());
    }

    private static ResourceFilter toResourceFilter(org.opennms.integration.api.v1.config.thresholding.ResourceFilter resourceFilter) {
        ResourceFilter newResourceFilter = new ResourceFilter();
        resourceFilter.getContent().ifPresent(arg_0 -> ((ResourceFilter)newResourceFilter).setContent(arg_0));
        newResourceFilter.setField(resourceFilter.getField());
        return newResourceFilter;
    }
}

