/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.collectors;

import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.opennms.features.apilayer.collectors.CollectionSetMapper;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.CollectionSetPersistenceService;
import org.opennms.integration.api.v1.collectors.RrdRepository;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.model.ResourceTypeUtils;

public class CollectionSetPersistenceServiceImpl
implements CollectionSetPersistenceService {
    private static final ServiceParameters EMPTY_SERVICE_PARAMETERS = new ServiceParameters(Collections.emptyMap());
    private static final org.opennms.netmgt.rrd.RrdRepository DEFAULT_RRD_REPOSITORY;
    private final CollectionAgentFactory collectionAgentFactory;
    private final PersisterFactory persisterFactory;

    public CollectionSetPersistenceServiceImpl(CollectionAgentFactory collectionAgentFactory, PersisterFactory persisterFactory) {
        this.collectionAgentFactory = Objects.requireNonNull(collectionAgentFactory);
        this.persisterFactory = Objects.requireNonNull(persisterFactory);
    }

    public void persist(int nodeId, InetAddress iface, CollectionSet collectionSet) {
        this.persist(nodeId, iface, collectionSet, DEFAULT_RRD_REPOSITORY);
    }

    public void persist(int nodeId, InetAddress iface, CollectionSet collectionSet, RrdRepository repository) {
        this.persist(nodeId, iface, collectionSet, CollectionSetPersistenceServiceImpl.toRepository(repository));
    }

    private void persist(int nodeId, InetAddress iface, CollectionSet collectionSet, org.opennms.netmgt.rrd.RrdRepository repository) {
        CollectionAgent agent = this.collectionAgentFactory.createCollectionAgent(Integer.toString(nodeId), iface);
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        org.opennms.netmgt.collection.api.CollectionSet internalCollectionSet = CollectionSetMapper.buildCollectionSet(builder, collectionSet);
        repository.setRrdBaseDir(new File(ResourceTypeUtils.DEFAULT_RRD_ROOT, "snmp"));
        Persister persister = this.persisterFactory.createPersister(EMPTY_SERVICE_PARAMETERS, repository);
        internalCollectionSet.visit((CollectionSetVisitor)persister);
    }

    private static org.opennms.netmgt.rrd.RrdRepository toRepository(RrdRepository repository) {
        org.opennms.netmgt.rrd.RrdRepository rrdRepository = new org.opennms.netmgt.rrd.RrdRepository();
        rrdRepository.setStep(repository.getStep());
        rrdRepository.setHeartBeat(repository.getHeartbeat());
        rrdRepository.setRraList(repository.getRRAs());
        return rrdRepository;
    }

    static {
        org.opennms.netmgt.rrd.RrdRepository repository = new org.opennms.netmgt.rrd.RrdRepository();
        repository.setStep(300);
        repository.setHeartBeat(repository.getStep() * 2);
        repository.setRraList(Arrays.asList("RRA:AVERAGE:0.5:1:2016", "RRA:AVERAGE:0.5:12:1488", "RRA:AVERAGE:0.5:288:366", "RRA:MAX:0.5:288:366", "RRA:MIN:0.5:288:366"));
        DEFAULT_RRD_REPOSITORY = repository;
    }
}

