package org.opennms.features.apilayer.model.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.mapstruct.factory.Mappers;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MetaData;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.immutables.ImmutableNode;
import org.opennms.integration.api.v1.model.immutables.ImmutableNode.Builder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-02-03T13:30:47-0500",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_242 (Private Build)"
)
public class NodeMapperImpl implements NodeMapper {

    private final NodeAssetRecordMapper nodeAssetRecordMapper = Mappers.getMapper( NodeAssetRecordMapper.class );
    private final IpInterfaceMapper ipInterfaceMapper = Mappers.getMapper( IpInterfaceMapper.class );
    private final SnmpInterfaceMapper snmpInterfaceMapper = Mappers.getMapper( SnmpInterfaceMapper.class );
    private final MetaDataMapper metaDataMapper = Mappers.getMapper( MetaDataMapper.class );

    @Override
    public ImmutableNode map(OnmsNode onmsNode) {
        if ( onmsNode == null ) {
            return null;
        }

        Builder immutableNode = ImmutableNode.newBuilder();

        if ( onmsNode.getId() != null ) {
            immutableNode.setId( onmsNode.getId() );
        }
        immutableNode.setForeignSource( onmsNode.getForeignSource() );
        immutableNode.setForeignId( onmsNode.getForeignId() );
        immutableNode.setLabel( onmsNode.getLabel() );
        immutableNode.setLocation( mapLocation( onmsNode.getLocation() ) );
        immutableNode.setAssetRecord( nodeAssetRecordMapper.map( onmsNode.getAssetRecord() ) );
        immutableNode.setIpInterfaces( onmsIpInterfaceSetToIpInterfaceList( onmsNode.getIpInterfaces() ) );
        immutableNode.setSnmpInterfaces( onmsSnmpInterfaceSetToSnmpInterfaceList( onmsNode.getSnmpInterfaces() ) );
        immutableNode.setMetaData( onmsMetaDataListToMetaDataList( onmsNode.getMetaData() ) );

        return immutableNode.build();
    }

    protected List<IpInterface> onmsIpInterfaceSetToIpInterfaceList(Set<OnmsIpInterface> set) {
        if ( set == null ) {
            return null;
        }

        List<IpInterface> list = new ArrayList<IpInterface>( set.size() );
        for ( OnmsIpInterface onmsIpInterface : set ) {
            list.add( ipInterfaceMapper.map( onmsIpInterface ) );
        }

        return list;
    }

    protected List<SnmpInterface> onmsSnmpInterfaceSetToSnmpInterfaceList(Set<OnmsSnmpInterface> set) {
        if ( set == null ) {
            return null;
        }

        List<SnmpInterface> list = new ArrayList<SnmpInterface>( set.size() );
        for ( OnmsSnmpInterface onmsSnmpInterface : set ) {
            list.add( snmpInterfaceMapper.map( onmsSnmpInterface ) );
        }

        return list;
    }

    protected List<MetaData> onmsMetaDataListToMetaDataList(List<OnmsMetaData> list) {
        if ( list == null ) {
            return null;
        }

        List<MetaData> list1 = new ArrayList<MetaData>( list.size() );
        for ( OnmsMetaData onmsMetaData : list ) {
            list1.add( metaDataMapper.map( onmsMetaData ) );
        }

        return list1;
    }
}
