/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import org.opennms.features.apilayer.model.mappers.AlarmFeedbackMapper;
import org.opennms.features.apilayer.model.mappers.DatabaseEventMapper;
import org.opennms.features.apilayer.model.mappers.InMemoryEventMapper;
import org.opennms.features.apilayer.model.mappers.NodeMapper;
import org.opennms.features.apilayer.model.mappers.SnmpInterfaceMapper;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.TopologyProtocol;
import org.opennms.integration.api.v1.model.immutables.ImmutableAlarm;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.xml.event.Event;

public class ModelMappers {
    private static final InMemoryEventMapper inMemoryEventMapper = (InMemoryEventMapper)Mappers.getMapper(InMemoryEventMapper.class);
    private static final DatabaseEventMapper databaseEventMapper = (DatabaseEventMapper)Mappers.getMapper(DatabaseEventMapper.class);
    private static final NodeMapper nodeMapper = (NodeMapper)Mappers.getMapper(NodeMapper.class);
    private static final SnmpInterfaceMapper snmpInterfaceMapper = (SnmpInterfaceMapper)Mappers.getMapper(SnmpInterfaceMapper.class);
    private static final AlarmFeedbackMapper alarmFeedbackMapper = (AlarmFeedbackMapper)Mappers.getMapper(AlarmFeedbackMapper.class);

    public static Alarm toAlarm(OnmsAlarm alarm) {
        return alarm == null ? null : ImmutableAlarm.newBuilder().setReductionKey(alarm.getReductionKey()).setId(alarm.getId()).setNode(ModelMappers.toNode(alarm.getNode())).setManagedObjectInstance(alarm.getManagedObjectInstance()).setManagedObjectType(alarm.getManagedObjectType()).setAttributes(alarm.getDetails()).setSeverity(ModelMappers.toSeverity(alarm.getSeverity())).setRelatedAlarms(alarm.getRelatedAlarms().stream().map(ModelMappers::toAlarm).collect(Collectors.toList())).setLogMessage(alarm.getLogMsg()).setDescription(alarm.getDescription()).setLastEventTime(alarm.getLastEventTime()).setFirstEventTime(alarm.getFirstEventTime()).setLastEvent(ModelMappers.toEvent(alarm.getLastEvent())).build();
    }

    public static InMemoryEvent toEvent(Event event) {
        return event == null ? null : inMemoryEventMapper.map(event);
    }

    public static Event toEvent(InMemoryEvent event) {
        EventBuilder builder = new EventBuilder(event.getUei(), event.getSource());
        if (event.getNodeId() != null) {
            builder.setNodeid(event.getNodeId().longValue());
        }
        if (event.getSeverity() != null) {
            builder.setSeverity(OnmsSeverity.get((int)event.getSeverity().getId()).getLabel());
        }
        for (EventParameter p : event.getParameters()) {
            builder.setParam(p.getName(), p.getValue());
        }
        return builder.getEvent();
    }

    public static DatabaseEvent toEvent(OnmsEvent event) {
        return event == null ? null : databaseEventMapper.map(event);
    }

    public static Node toNode(OnmsNode node) {
        return node == null ? null : nodeMapper.map(node);
    }

    public static SnmpInterface toSnmpInterface(OnmsSnmpInterface snmpInterface) {
        return snmpInterface == null ? null : snmpInterfaceMapper.map(snmpInterface);
    }

    public static Severity toSeverity(OnmsSeverity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case CLEARED: {
                return Severity.CLEARED;
            }
            case NORMAL: {
                return Severity.NORMAL;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case MINOR: {
                return Severity.MINOR;
            }
            case MAJOR: {
                return Severity.MAJOR;
            }
            case CRITICAL: {
                return Severity.CRITICAL;
            }
        }
        return Severity.INDETERMINATE;
    }

    public static org.opennms.integration.api.v1.model.AlarmFeedback toFeedback(AlarmFeedback feedback) {
        return feedback == null ? null : alarmFeedbackMapper.map(feedback);
    }

    public static AlarmFeedback fromFeedback(org.opennms.integration.api.v1.model.AlarmFeedback feedback) {
        return feedback == null ? null : AlarmFeedback.newBuilder().withTimestamp(feedback.getTimestamp().longValue()).withAlarmKey(feedback.getAlarmKey()).withFeedbackType(AlarmFeedback.FeedbackType.valueOfOrUnknown((String)feedback.getFeedbackType().toString())).withReason(feedback.getReason()).withSituationFingerprint(feedback.getSituationFingerprint()).withSituationKey(feedback.getSituationKey()).withUser(feedback.getUser()).build();
    }

    public static OnmsTopologyProtocol toOnmsTopologyProtocol(TopologyProtocol protocol) {
        return OnmsTopologyProtocol.create((String)protocol.name());
    }

    public static TopologyProtocol toTopologyProtocol(OnmsTopologyProtocol protocol) {
        return TopologyProtocol.valueOf((String)protocol.getId());
    }
}

