/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.dao;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.dao.AlarmDao;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsAlarm;

public class AlarmDaoImpl
implements AlarmDao {
    private final org.opennms.netmgt.dao.api.AlarmDao alarmDao;
    private final SessionUtils sessionUtils;

    public AlarmDaoImpl(org.opennms.netmgt.dao.api.AlarmDao alarmDao, SessionUtils sessionUtils) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public Long getAlarmCount() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class);
        return (Long)this.sessionUtils.withReadOnlyTransaction(() -> this.alarmDao.countMatching(criteriaBuilder.toCriteria()));
    }

    public List<Alarm> getAlarms() {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.alarmDao.findAll().stream().map(ModelMappers::toAlarm).collect(Collectors.toList()));
    }
}

