package org.opennms.features.apilayer.model.mappers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.mapstruct.factory.Mappers;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.immutables.ImmutableInMemoryEvent;
import org.opennms.integration.api.v1.model.immutables.ImmutableInMemoryEvent.Builder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-07-30T16:52:42-0400",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_212 (Oracle Corporation)"
)
public class InMemoryEventMapperImpl implements InMemoryEventMapper {

    private final EventParameterMapper eventParameterMapper = Mappers.getMapper( EventParameterMapper.class );

    @Override
    public ImmutableInMemoryEvent map(Event event) {
        if ( event == null ) {
            return null;
        }

        Builder immutableInMemoryEvent = ImmutableInMemoryEvent.newBuilder();

        immutableInMemoryEvent.setParameters( parmListToEventParameterList( event.getParmCollection() ) );
        if ( event.hasNodeid() ) {
            immutableInMemoryEvent.setNodeId( event.getNodeid().intValue() );
        }
        immutableInMemoryEvent.setUei( event.getUei() );
        immutableInMemoryEvent.setSource( event.getSource() );
        immutableInMemoryEvent.setSeverity( map( event.getSeverity() ) );

        return immutableInMemoryEvent.build();
    }

    protected List<EventParameter> parmListToEventParameterList(List<Parm> list) {
        if ( list == null ) {
            return null;
        }

        List<EventParameter> list1 = new ArrayList<EventParameter>( list.size() );
        for ( Parm parm : list ) {
            list1.add( eventParameterMapper.map( parm ) );
        }

        return list1;
    }
}
