/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.model.EventParameterBean;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.netmgt.model.OnmsEvent;

public class DatabaseEventBean
implements DatabaseEvent {
    private final OnmsEvent event;
    private final List<EventParameter> parameters;

    public DatabaseEventBean(OnmsEvent event) {
        this.event = Objects.requireNonNull(event);
        this.parameters = ImmutableList.copyOf((Collection)event.getEventParameters().stream().map(EventParameterBean::new).collect(Collectors.toList()));
    }

    public String getUei() {
        return this.event.getEventUei();
    }

    public Integer getId() {
        return this.event.getId();
    }

    public List<EventParameter> getParameters() {
        return this.parameters;
    }

    public List<EventParameter> getParametersByName(String name) {
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).collect(Collectors.toList());
    }
}

