/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.model;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.utils.LocationUtils;
import org.opennms.features.apilayer.model.IpInterfaceBean;
import org.opennms.features.apilayer.model.NodeAssetRecordBean;
import org.opennms.features.apilayer.model.SnmpInterfaceBean;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.NodeAssetRecord;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;

public class NodeBean
implements Node {
    private final OnmsNode node;
    private final String location;
    private final NodeAssetRecord assetRecord;
    private final List<IpInterface> ipInterfaces;
    private final List<SnmpInterface> snmpInterfaces;

    public NodeBean(OnmsNode node) {
        this.node = Objects.requireNonNull(node);
        OnmsMonitoringLocation monitoringLocation = node.getLocation();
        this.location = monitoringLocation != null ? LocationUtils.getEffectiveLocationName((String)monitoringLocation.getLocationName()) : "Default";
        this.assetRecord = new NodeAssetRecordBean(node.getAssetRecord());
        this.ipInterfaces = node.getIpInterfaces().stream().map(IpInterfaceBean::new).collect(Collectors.toList());
        this.snmpInterfaces = node.getSnmpInterfaces().stream().map(SnmpInterfaceBean::new).collect(Collectors.toList());
    }

    public Integer getId() {
        return this.node.getId();
    }

    public String getForeignSource() {
        return this.node.getForeignSource();
    }

    public String getForeignId() {
        return this.node.getForeignId();
    }

    public String getLabel() {
        return this.node.getLabel();
    }

    public String getLocation() {
        return this.location;
    }

    public NodeAssetRecord getAssetRecord() {
        return this.assetRecord;
    }

    public List<IpInterface> getIpInterfaces() {
        return this.ipInterfaces;
    }

    public List<SnmpInterface> getSnmpInterfaces() {
        return this.snmpInterfaces;
    }
}

