/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.model.EventParameterBean;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;

public class InMemoryEventBean
implements InMemoryEvent {
    private final Event event;
    private final Severity severity;
    private final List<EventParameter> parameters;

    public InMemoryEventBean(Event event) {
        this.event = Objects.requireNonNull(event);
        this.severity = ModelMappers.toSeverity(OnmsSeverity.get((String)event.getSeverity()));
        this.parameters = ImmutableList.copyOf((Collection)event.getParmCollection().stream().filter(Objects::nonNull).map(EventParameterBean::new).collect(Collectors.toList()));
    }

    public String getUei() {
        return this.event.getUei();
    }

    public String getSource() {
        return this.event.getSource();
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<EventParameter> getParameters() {
        return this.parameters;
    }

    public Optional<String> getParameterValue(String name) {
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).map(EventParameter::getValue).findFirst();
    }

    public List<EventParameter> getParametersByName(String name) {
        return this.parameters.stream().filter(p -> Objects.equals(name, p.getName())).collect(Collectors.toList());
    }
}

