/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.collectors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.apilayer.collectors.CollectionSetMapper;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.CollectorRequestBuilder;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetBuilder;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.LocationAwareCollectorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorRequestBuilderImpl
implements CollectorRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorRequestBuilderImpl.class);
    private final LocationAwareCollectorClient locationAwareCollectorClient;
    private final CollectionAgentFactory collectionAgentFactory;
    private final NodeDao nodeDao;
    private CollectionRequest collectionRequest;
    private String className;
    private Long ttlInMs;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public CollectorRequestBuilderImpl(LocationAwareCollectorClient locationAwareCollectorClient, CollectionAgentFactory collectionAgentFactory, NodeDao nodeDao) {
        this.locationAwareCollectorClient = locationAwareCollectorClient;
        this.collectionAgentFactory = collectionAgentFactory;
        this.nodeDao = nodeDao;
    }

    public CollectorRequestBuilder withRequest(CollectionRequest request) {
        this.collectionRequest = request;
        return this;
    }

    public CollectorRequestBuilder withCollectorClassName(String className) {
        this.className = className;
        return this;
    }

    public CollectorRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public CollectorRequestBuilder withAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public CollectorRequestBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public CompletableFuture<CollectionSet> execute() {
        CollectionAgent collectionAgent = this.collectionAgentFactory.createCollectionAgent(this.collectionRequest.getNodeCriteria(), this.collectionRequest.getAddress());
        CompletableFuture result = this.locationAwareCollectorClient.collect().withAgent(collectionAgent).withCollectorClassName(this.className).withAttributes(this.attributes).withTimeToLive(this.ttlInMs).execute();
        CompletableFuture<CollectionSet> future = new CompletableFuture<CollectionSet>();
        try {
            org.opennms.netmgt.collection.api.CollectionSet collectionSet = (org.opennms.netmgt.collection.api.CollectionSet)result.get();
            CollectionSetBuilder builder = new CollectionSetBuilder();
            if (collectionSet.getStatus().equals((Object)CollectionStatus.FAILED)) {
                CollectionSet collectionSetResult = builder.withTimeStamp(collectionSet.getCollectionTimestamp().getTime()).withStatus(CollectionSet.Status.FAILED).build();
                future.complete(collectionSetResult);
            } else {
                CollectionSetMapper collectionSetMapper = new CollectionSetMapper(this.nodeDao);
                future.complete(collectionSetMapper.buildCollectionSet(builder, collectionSet));
            }
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

