/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.collectors;

import com.google.common.base.Enums;
import java.util.Date;
import java.util.List;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.resource.AttributeBuilder;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetBuilder;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResourceBuilder;
import org.opennms.integration.api.v1.collectors.resource.GenericTypeResource;
import org.opennms.integration.api.v1.collectors.resource.IpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.ResourceBuilder;
import org.opennms.integration.api.v1.collectors.resource.StringAttribute;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;

public class CollectionSetMapper {
    private NodeDao nodeDao;

    public CollectionSetMapper(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public org.opennms.integration.api.v1.collectors.CollectionSet buildCollectionSet(final CollectionSetBuilder builder, CollectionSet collectionSet) {
        collectionSet.visit(new CollectionSetVisitor(){
            CollectionSetResourceBuilder resourceBuilder;
            String groupName = null;

            public void visitCollectionSet(CollectionSet set) {
            }

            public void visitResource(CollectionResource resource) {
                this.resourceBuilder = new CollectionSetResourceBuilder();
                if (resource.getResourceTypeName().equals("node")) {
                    this.resourceBuilder.withResource((org.opennms.integration.api.v1.collectors.resource.Resource)CollectionSetMapper.this.buildNodeResource(resource));
                } else if (resource.getResourceTypeName().equals("if")) {
                    IpInterfaceResource ipInterfaceResource = new ResourceBuilder().withInstance(resource.getInstance()).buildIpInterfaceResource(CollectionSetMapper.this.buildNodeResource(resource));
                    this.resourceBuilder.withResource((org.opennms.integration.api.v1.collectors.resource.Resource)ipInterfaceResource);
                } else {
                    GenericTypeResource genericTypeResource = new ResourceBuilder().withInstance(resource.getInstance()).withType(resource.getResourceTypeName()).buildGenericTypeResource(CollectionSetMapper.this.buildNodeResource(resource));
                    this.resourceBuilder.withResource((org.opennms.integration.api.v1.collectors.resource.Resource)genericTypeResource);
                }
            }

            public void visitGroup(AttributeGroup group) {
                this.groupName = group.getName();
            }

            public void visitAttribute(CollectionAttribute attribute) {
                if (attribute.getType().equals((Object)AttributeType.STRING)) {
                    StringAttribute stringAttribute = new AttributeBuilder().withName(attribute.getName()).withStringValue(attribute.getStringValue()).buildString();
                    this.resourceBuilder.withStringAttribute(stringAttribute);
                } else {
                    NumericAttribute numericAttribute = new AttributeBuilder().withName(attribute.getName()).withGroup(this.groupName).withType(attribute.getType() == AttributeType.COUNTER ? NumericAttribute.Type.COUNTER : NumericAttribute.Type.GAUGE).withNumericValue(attribute.getNumericValue().doubleValue()).buildNumeric();
                    this.resourceBuilder.withNumericAttribute(numericAttribute);
                }
            }

            public void completeAttribute(CollectionAttribute attribute) {
            }

            public void completeGroup(AttributeGroup group) {
            }

            public void completeResource(CollectionResource resource) {
                builder.withCollectionSetResource(this.resourceBuilder.build());
            }

            public void completeCollectionSet(CollectionSet set) {
                builder.withTimeStamp(set.getCollectionTimestamp().getTime());
                builder.withStatus(CollectionSet.Status.SUCCEEDED);
            }
        });
        return builder.build();
    }

    private NodeResource buildNodeResource(CollectionResource collectionResource) {
        String nodeCriteria = this.getNodeCriteriaFromResource(collectionResource);
        Node node = this.nodeDao.getNodeByCriteria(nodeCriteria);
        NodeResource nodeResource = new ResourceBuilder().withNodeId(node.getId()).withForeignId(node.getForeignId()).withForeignSource(node.getForeignSource()).withNodeLabel(node.getLabel()).buildNodeResource();
        return nodeResource;
    }

    private String getNodeCriteriaFromResource(CollectionResource resource) {
        String nodeCriteria = null;
        if (resource.getParent() != null) {
            String[] resourcePathArray = resource.getParent().elements();
            if ("fs".equals(resourcePathArray[0]) && resourcePathArray.length == 3) {
                nodeCriteria = resourcePathArray[1] + ":" + resourcePathArray[2];
            } else if (this.checkNumeric(resourcePathArray[0])) {
                nodeCriteria = resourcePathArray[0];
            }
        }
        return nodeCriteria;
    }

    private boolean checkNumeric(String nodeCriteria) {
        try {
            Integer.parseInt(nodeCriteria);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static CollectionSet buildCollectionSet(org.opennms.netmgt.collection.support.builder.CollectionSetBuilder builder, org.opennms.integration.api.v1.collectors.CollectionSet collectionSet) {
        for (CollectionSetResource collectionSetResource : collectionSet.getCollectionSetResources()) {
            NodeLevelResource nodeLevelResource;
            org.opennms.integration.api.v1.collectors.resource.Resource resource = collectionSetResource.getResource();
            if (resource == null) continue;
            if (resource.getResourceType().equals((Object)Resource.Type.NODE)) {
                NodeResource nodeResource = (NodeResource)resource;
                nodeLevelResource = new NodeLevelResource(nodeResource.getNodeId().intValue());
                CollectionSetMapper.addAttributes(collectionSetResource, builder, (Resource)nodeLevelResource);
                continue;
            }
            if (resource.getResourceType().equals((Object)Resource.Type.INTERFACE)) {
                IpInterfaceResource ipResource = (IpInterfaceResource)resource;
                nodeLevelResource = new NodeLevelResource(ipResource.getNodeResource().getNodeId().intValue());
                InterfaceLevelResource interfaceLevelResource = new InterfaceLevelResource(nodeLevelResource, ipResource.getInstance());
                CollectionSetMapper.addAttributes(collectionSetResource, builder, (Resource)interfaceLevelResource);
                continue;
            }
            if (!resource.getResourceType().equals((Object)Resource.Type.GENERIC)) continue;
            GenericTypeResource genericTypeResource = (GenericTypeResource)resource;
            nodeLevelResource = new NodeLevelResource(genericTypeResource.getNodeResource().getNodeId().intValue());
            DeferredGenericTypeResource deferredGenericTypeResource = new DeferredGenericTypeResource(nodeLevelResource, genericTypeResource.getType(), genericTypeResource.getInstance());
            CollectionSetMapper.addAttributes(collectionSetResource, builder, (Resource)deferredGenericTypeResource);
        }
        builder.withTimestamp(new Date(collectionSet.getTimeStamp()));
        return builder.build();
    }

    public static void addAttributes(CollectionSetResource collectionSetResource, org.opennms.netmgt.collection.support.builder.CollectionSetBuilder builder, Resource resource) {
        List numericAttributes = collectionSetResource.getNumericAttributes();
        for (NumericAttribute numericAttribute : numericAttributes) {
            AttributeType attributeType = (AttributeType)Enums.getIfPresent(AttributeType.class, (String)numericAttribute.getType().name()).or((Object)AttributeType.GAUGE);
            builder.withNumericAttribute(resource, numericAttribute.getGroup(), numericAttribute.getName(), (Number)numericAttribute.getValue(), attributeType);
        }
        List stringAttributes = collectionSetResource.getStringAttributes();
        for (StringAttribute stringAttribute : stringAttributes) {
            builder.withStringAttribute(resource, stringAttribute.getGroup(), stringAttribute.getName(), stringAttribute.getValue());
        }
    }
}

