/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.dao;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;

public class NodeDaoImpl
implements org.opennms.integration.api.v1.dao.NodeDao {
    private final NodeDao nodeDao;
    private final SessionUtils sessionUtils;

    public NodeDaoImpl(NodeDao nodeDao, SessionUtils sessionUtils) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public List<Node> getNodes() {
        return (List)this.sessionUtils.withTransaction(() -> this.nodeDao.findAll().stream().map(ModelMappers::toNode).collect(Collectors.toList()));
    }

    public Long getNodeCount() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class);
        return this.nodeDao.countMatching(criteriaBuilder.toCriteria());
    }

    public List<Integer> getNodeIds() {
        return Lists.newArrayList((Iterable)this.nodeDao.getNodeIds());
    }

    public Node getNodeByCriteria(String nodeCriteria) {
        return ModelMappers.toNode(this.nodeDao.get(nodeCriteria));
    }

    public Node getNodeById(Integer nodeId) {
        return (Node)this.sessionUtils.withTransaction(() -> ModelMappers.toNode((OnmsNode)this.nodeDao.get((Serializable)nodeId)));
    }

    public Node getNodeByLabel(String nodeLabel) {
        return (Node)this.sessionUtils.withTransaction(() -> ModelMappers.toNode(this.nodeDao.findByLabel(nodeLabel).stream().min(Comparator.comparingInt(OnmsNode::getId)).orElse(null)));
    }

    public Node getNodeByForeignSourceAndForeignId(String foreignSource, String foreignId) {
        return (Node)this.sessionUtils.withTransaction(() -> ModelMappers.toNode(this.nodeDao.findByForeignId(foreignSource, foreignId)));
    }
}

