/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import org.opennms.features.apilayer.model.AlarmBean;
import org.opennms.features.apilayer.model.DatabaseEventBean;
import org.opennms.features.apilayer.model.InMemoryEventBean;
import org.opennms.features.apilayer.model.NodeBean;
import org.opennms.features.apilayer.model.SnmpInterfaceBean;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;

public class ModelMappers {
    public static Alarm toAlarm(OnmsAlarm alarm) {
        return new AlarmBean(alarm);
    }

    public static InMemoryEvent toEvent(Event event) {
        return new InMemoryEventBean(event);
    }

    public static Event toEvent(InMemoryEvent event) {
        EventBuilder builder = new EventBuilder(event.getUei(), event.getSource());
        if (event.getSeverity() != null) {
            builder.setSeverity(OnmsSeverity.get((int)event.getSeverity().getId()).getLabel());
        }
        for (EventParameter p : event.getParameters()) {
            builder.setParam(p.getName(), p.getValue());
        }
        return builder.getEvent();
    }

    public static DatabaseEvent toEvent(OnmsEvent event) {
        if (event == null) {
            return null;
        }
        return new DatabaseEventBean(event);
    }

    public static Node toNode(OnmsNode node) {
        if (node == null) {
            return null;
        }
        return new NodeBean(node);
    }

    public static SnmpInterface toSnmpInterface(OnmsSnmpInterface snmpInterface) {
        if (snmpInterface == null) {
            return null;
        }
        return new SnmpInterfaceBean(snmpInterface);
    }

    public static Severity toSeverity(OnmsSeverity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case CLEARED: {
                return Severity.CLEARED;
            }
            case NORMAL: {
                return Severity.NORMAL;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case MINOR: {
                return Severity.MINOR;
            }
            case MAJOR: {
                return Severity.MAJOR;
            }
            case CRITICAL: {
                return Severity.CRITICAL;
            }
        }
        return Severity.INDETERMINATE;
    }
}

