/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterfaceMapper<S, T> {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceMapper.class);
    private final Class<T> clazz;
    private final BundleContext bundleContext;
    private final Map<S, ServiceRegistration<T>> extServiceRegistrationMap = new LinkedHashMap<S, ServiceRegistration<T>>();

    public InterfaceMapper(Class<T> clazz, BundleContext bundleContext) {
        this.clazz = Objects.requireNonNull(clazz);
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public synchronized void onBind(S extension, Map properties) {
        LOG.debug("bind called with {}: {}", extension, (Object)properties);
        if (extension != null) {
            this.extServiceRegistrationMap.computeIfAbsent(extension, ext -> {
                T mappedExt = this.map(ext);
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("registration.export", Boolean.TRUE.toString());
                return this.bundleContext.registerService(this.clazz, mappedExt, props);
            });
        }
    }

    public synchronized void onUnbind(S extension, Map properties) {
        ServiceRegistration<T> registration;
        LOG.debug("unbind called with {}: {}", extension, (Object)properties);
        if (extension != null && (registration = this.extServiceRegistrationMap.remove(extension)) != null) {
            registration.unregister();
        }
    }

    public abstract T map(S var1);
}

