/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.model;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.model.NodeBean;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.config.events.AlarmType;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.netmgt.model.OnmsAlarm;

public class AlarmBean
implements Alarm {
    private final OnmsAlarm alarm;
    private final NodeBean node;
    private final Map<String, String> attributes;
    private final Severity severity;
    private final List<Alarm> relatedAlarms;
    private final DatabaseEvent lastEvent;

    public AlarmBean(OnmsAlarm alarm) {
        this.alarm = Objects.requireNonNull(alarm);
        this.attributes = alarm.getDetails() != null ? ImmutableMap.copyOf((Map)alarm.getDetails()) : Collections.emptyMap();
        this.node = alarm.getNode() != null ? new NodeBean(alarm.getNode()) : null;
        this.severity = ModelMappers.toSeverity(alarm.getSeverity());
        this.relatedAlarms = alarm.getRelatedAlarms().stream().map(AlarmBean::new).collect(Collectors.toList());
        this.lastEvent = ModelMappers.toEvent(alarm.getLastEvent());
    }

    public String getReductionKey() {
        return this.alarm.getReductionKey();
    }

    public Integer getId() {
        return this.alarm.getId();
    }

    public Node getNode() {
        return this.node;
    }

    public AlarmType getType() {
        return null;
    }

    public String getManagedObjectInstance() {
        return this.alarm.getManagedObjectInstance();
    }

    public String getManagedObjectType() {
        return this.alarm.getManagedObjectType();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isSituation() {
        return this.relatedAlarms.size() > 0;
    }

    public List<Alarm> getRelatedAlarms() {
        return this.relatedAlarms;
    }

    public String getLogMessage() {
        return this.alarm.getLogMsg();
    }

    public String getDescription() {
        return this.alarm.getDescription();
    }

    public Date getLastEventTime() {
        return this.alarm.getLastEventTime();
    }

    public Date getFirstEventTime() {
        return this.alarm.getFirstEventTime();
    }

    public DatabaseEvent getLastEvent() {
        return this.lastEvent;
    }
}

