/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.accesspointmonitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.config.accesspointmonitor.Parameter;

@XmlType(name="service-template")
public class ServiceTemplate
implements Serializable,
Comparable<ServiceTemplate> {
    private static final long serialVersionUID = -7451942028852991463L;
    protected static final Parameter[] OF_PARAMETERS = new Parameter[0];
    @XmlAttribute(name="name")
    protected String m_name;
    @XmlAttribute(name="threads")
    protected Integer m_threads;
    @XmlAttribute(name="passive-service-name")
    protected String m_passiveServiceName;
    @XmlAttribute(name="interval")
    protected Long m_interval;
    @XmlAttribute(name="status")
    protected String m_status;
    @XmlElement(name="parameter")
    protected List<Parameter> m_parameters = new ArrayList<Parameter>();

    public ServiceTemplate() {
    }

    public ServiceTemplate(ServiceTemplate copy) {
        if (copy.m_name != null) {
            this.m_name = new String(copy.m_name);
        }
        if (copy.m_threads != null) {
            this.m_threads = (int)copy.m_threads;
        }
        if (copy.m_passiveServiceName != null) {
            this.m_passiveServiceName = new String(copy.m_passiveServiceName);
        }
        if (copy.m_interval != null) {
            this.m_interval = (long)copy.m_interval;
        }
        if (copy.m_status != null) {
            this.m_status = new String(copy.m_status);
        }
        for (Parameter p : copy.m_parameters) {
            this.m_parameters.add(new Parameter(p));
        }
    }

    @XmlTransient
    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.m_parameters = parameters;
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public void removeParameter(Parameter parameter) {
        this.m_parameters.remove(parameter);
    }

    public void removeParameterByKey(String key) {
        for (Parameter parameter : this.m_parameters) {
            if (!parameter.getKey().equals(key)) continue;
            this.m_parameters.remove(parameter);
            return;
        }
    }

    @XmlTransient
    public Map<String, String> getParameterMap() {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (Parameter p : this.getParameters()) {
            parameterMap.put(p.getKey(), p.getValue());
        }
        return parameterMap;
    }

    @XmlTransient
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @XmlTransient
    public Integer getThreads() {
        return this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = threads;
    }

    @XmlTransient
    public String getPassiveServiceName() {
        return this.m_passiveServiceName;
    }

    public void setPassiveServiceName(String passiveServiceName) {
        this.m_passiveServiceName = passiveServiceName;
    }

    @XmlTransient
    public Long getInterval() {
        return this.m_interval;
    }

    public void setInterval(Long interval) {
        this.m_interval = interval;
    }

    @XmlTransient
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @Override
    public int compareTo(ServiceTemplate obj) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)obj.getName()).append((Object)this.getThreads(), (Object)obj.getThreads()).append((Object)this.getPassiveServiceName(), (Object)obj.getPassiveServiceName()).append((Object)this.getInterval(), (Object)obj.getInterval()).append((Object)this.getStatus(), (Object)obj.getStatus()).append((Object[])this.getParameters().toArray(OF_PARAMETERS), (Object[])obj.getParameters().toArray(OF_PARAMETERS)).toComparison();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_interval == null ? 0 : this.m_interval.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_parameters == null ? 0 : ((Object)this.m_parameters).hashCode());
        result = 31 * result + (this.m_passiveServiceName == null ? 0 : this.m_passiveServiceName.hashCode());
        result = 31 * result + (this.m_status == null ? 0 : this.m_status.hashCode());
        result = 31 * result + (this.m_threads == null ? 0 : this.m_threads.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceTemplate) {
            ServiceTemplate other = (ServiceTemplate)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getThreads(), (Object)other.getThreads()).append((Object)this.getPassiveServiceName(), (Object)other.getPassiveServiceName()).append((Object)this.getInterval(), (Object)other.getInterval()).append((Object)this.getStatus(), (Object)other.getStatus()).append((Object[])this.getParameters().toArray(OF_PARAMETERS), (Object[])other.getParameters().toArray(OF_PARAMETERS)).isEquals();
        }
        return false;
    }
}

