/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.accesspointmonitor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.opennms.netmgt.accesspointmonitor.DefaultPollingContext;
import org.opennms.netmgt.accesspointmonitor.PollingContext;
import org.opennms.netmgt.config.accesspointmonitor.AccessPointMonitorConfig;
import org.opennms.netmgt.config.accesspointmonitor.AccessPointMonitorConfigFactory;
import org.opennms.netmgt.config.accesspointmonitor.Package;
import org.opennms.netmgt.config.accesspointmonitor.Service;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.AccessPointDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

@EventListener(name="AccessPointMonitor")
public class AccessPointMonitord
extends AbstractServiceDaemon
implements ReadyRunnable {
    private static final String DAEMON_NAME = "AccessPointMonitor";
    private static AccessPointMonitord m_singleton = new AccessPointMonitord();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private EventIpcManager m_eventMgr = null;
    private AccessPointMonitorConfig m_pollerConfig;
    private AccessPointDao m_accessPointDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private volatile Map<String, PollingContext> m_activePollers = new HashMap<String, PollingContext>();

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public AccessPointDao getAccessPointDao() {
        return this.m_accessPointDao;
    }

    public void setAccessPointDao(AccessPointDao accessPointDao) {
        this.m_accessPointDao = accessPointDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public AccessPointMonitorConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(AccessPointMonitorConfig accesspointmonitorConfig) {
        this.m_pollerConfig = accesspointmonitorConfig;
    }

    protected void onStart() {
        try {
            this.log().debug("onStart: Starting Access Point Monitor scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            this.log().fatal("onStart: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStop() {
        if (this.getScheduler() != null) {
            this.log().debug("onStop: stopping scheduler");
            this.getScheduler().stop();
        }
        this.setScheduler(null);
        this.log().debug("onStop: releasing pollers");
        Map<String, PollingContext> map = this.m_activePollers;
        synchronized (map) {
            if (this.m_activePollers != null) {
                for (PollingContext p : this.m_activePollers.values()) {
                    p.release();
                }
                this.m_activePollers.clear();
            }
        }
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public static void setInstance(AccessPointMonitord apm) {
        m_singleton = apm;
    }

    public static AccessPointMonitord getInstance() {
        return m_singleton;
    }

    public AccessPointMonitord() {
        super("OpenNMS.AccessPointMonitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInit() {
        this.createScheduler();
        Map<String, PollingContext> map = this.m_activePollers;
        synchronized (map) {
            this.m_activePollers.clear();
        }
        this.log().debug("onInit: Scheduling packages for polling");
        this.scheduleStaticPackages();
        this.scheduleDynamicPackages();
        this.getScheduler().schedule(this.getPollerConfig().getPackageScanInterval(), (ReadyRunnable)this);
        this.m_initialized = true;
    }

    private void createScheduler() {
        try {
            this.log().debug("init: Creating Access Point Monitor scheduler");
            this.setScheduler(new LegacyScheduler(DAEMON_NAME, this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            this.log().fatal("init: Failed to create Access Point Monitor scheduler", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDynamicPackages() {
        PollingContext p;
        this.log().debug("scheduleDynamicPackages() was triggered");
        HashMap<String, Package> dynamicPackages = new HashMap<String, Package>();
        for (Package pkg : this.m_pollerConfig.getPackages()) {
            if (!pkg.nameHasWildcard()) continue;
            for (String pkgName : this.m_accessPointDao.findDistinctPackagesLike(pkg.getName())) {
                Package newPkg = new Package(pkg);
                newPkg.setName(pkgName);
                newPkg.setIsDynamic(true);
                dynamicPackages.put(pkgName, newPkg);
            }
        }
        for (Package pkg : dynamicPackages.values()) {
            Map<String, PollingContext> i$ = this.m_activePollers;
            synchronized (i$) {
                p = this.m_activePollers.get(pkg.getName());
                if (p != null) {
                    if (p.getPackage().getIsDynamic()) {
                        this.log().debug("Package '" + pkg.getName() + "' is already active.");
                    } else {
                        this.log().error("Package '" + pkg.getName() + "' is statically defined and matches a dynamic definitions.");
                    }
                } else {
                    this.schedulePackage(pkg);
                }
            }
        }
        Map<String, PollingContext> map = this.m_activePollers;
        synchronized (map) {
            Iterator<Map.Entry<String, PollingContext>> entries = this.m_activePollers.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, PollingContext> entry = entries.next();
                p = entry.getValue();
                Package pkg = p.getPackage();
                if (!pkg.getIsDynamic() || dynamicPackages.containsKey(entry.getKey())) continue;
                this.log().debug("unscheduling " + pkg.getName());
                p.release();
                entries.remove();
            }
        }
    }

    private void scheduleStaticPackages() {
        for (Package pkg : this.m_pollerConfig.getPackages()) {
            if (pkg.nameHasWildcard()) continue;
            this.schedulePackage(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePackage(Package pkg) {
        Service svc = pkg.getEffectiveService();
        DefaultPollingContext p = new DefaultPollingContext();
        p.setPackage(pkg);
        p.setPollerConfig(this.getPollerConfig());
        p.setIpInterfaceDao(this.getIpInterfaceDao());
        p.setNodeDao(this.getNodeDao());
        p.setAccessPointDao(this.getAccessPointDao());
        p.setEventManager(this.getEventManager());
        p.setScheduler(this.getScheduler());
        p.setInterval(svc.getInterval());
        p.setPropertyMap(svc.getParameterMap());
        p.init();
        this.log().debug("schedulePackages: Scheduling " + pkg.getName() + " every " + svc.getInterval());
        this.getScheduler().schedule(svc.getInterval().longValue(), (ReadyRunnable)p);
        Map<String, PollingContext> map = this.m_activePollers;
        synchronized (map) {
            this.m_activePollers.put(pkg.getName(), p);
        }
    }

    private void initializeConfiguration() throws IOException, JAXBException {
        this.setPollerConfig(AccessPointMonitorConfigFactory.getInstance().getConfig());
    }

    private void reloadAndReStart() {
        EventBuilder ebldr = null;
        try {
            this.initializeConfiguration();
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", DAEMON_NAME);
            this.stop();
            this.init();
            this.start();
        }
        catch (JAXBException e) {
            this.fatalf(e, "Unable to initialize the Access Point Monitor configuration factory", new Object[0]);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", DAEMON_NAME);
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (IOException e) {
            this.fatalf(e, "Unable to initialize the Access Point Monitor configuration factory", new Object[0]);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", DAEMON_NAME);
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        this.m_eventMgr.sendNow(ebldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void reloadDaemonConfig(Event e) {
        this.log().info("reloadDaemonConfig: processing reload daemon event...");
        if (this.isReloadConfigEventTarget(e)) {
            this.reloadAndReStart();
        }
        this.log().info("reloadDaemonConfig: reload daemon event processed.");
    }

    private boolean isReloadConfigEventTarget(Event e) {
        boolean isTarget = false;
        List parmCollection = e.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !DAEMON_NAME.equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        this.log().debug("isReloadConfigEventTarget: AccessPointMonitor was target of reload event: " + isTarget);
        return isTarget;
    }

    public void run() {
        this.scheduleDynamicPackages();
        this.getScheduler().schedule(this.getPollerConfig().getPackageScanInterval(), (ReadyRunnable)this);
    }

    public boolean isReady() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActivePackageNames() {
        Map<String, PollingContext> map = this.m_activePollers;
        synchronized (map) {
            return this.m_activePollers.keySet();
        }
    }
}

