/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.accesspointmonitor.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.AccessPointDao;
import org.opennms.netmgt.model.OnmsAccessPoint;
import org.opennms.netmgt.model.OnmsAccessPointCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="accesspoints")
public class AccessPointRestService {
    @Autowired
    private AccessPointDao m_accessPointDao;
    @Context
    private UriInfo m_uriInfo;
    @Context
    private SecurityContext m_securityContext;
    @Context
    private ServletContext m_servletContext;
    private final ReentrantReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{accessPointId}")
    @Transactional
    public OnmsAccessPoint getOutage(@PathParam(value="accessPointId") String accessPointId) {
        this.readLock();
        try {
            OnmsAccessPoint onmsAccessPoint = (OnmsAccessPoint)this.m_accessPointDao.get(Integer.valueOf(accessPointId));
            return onmsAccessPoint;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_accessPointDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsAccessPointCollection getAccessPoints() {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(OnmsAccessPoint.class);
            OnmsAccessPointCollection coll = new OnmsAccessPointCollection(this.m_accessPointDao.findAll());
            coll.setTotalCount(this.m_accessPointDao.countMatching(builder.count().toCriteria()));
            OnmsAccessPointCollection onmsAccessPointCollection = coll;
            return onmsAccessPointCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    protected void readLock() {
        this.m_readLock.lock();
    }

    protected void readUnlock() {
        if (this.m_globalLock.getReadHoldCount() > 0) {
            this.m_readLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.m_globalLock.getWriteHoldCount() == 0) {
            while (this.m_globalLock.getReadHoldCount() > 0) {
                this.m_readLock.unlock();
            }
            this.m_writeLock.lock();
        }
    }

    protected void writeUnlock() {
        if (this.m_globalLock.getWriteHoldCount() > 0) {
            this.m_writeLock.unlock();
        }
    }
}

