/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.accesspointmonitor.poller;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.accesspointmonitor.poller.AccessPointPoller;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.accesspointmonitor.Package;
import org.opennms.netmgt.dao.AccessPointDao;
import org.opennms.netmgt.model.OnmsAccessPoint;
import org.opennms.netmgt.model.OnmsAccessPointCollection;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public class TableStrategy
implements AccessPointPoller {
    private OnmsIpInterface m_iface;
    private Package m_package;
    private Map<String, String> m_parameters;
    private AccessPointDao m_accessPointDao;

    @Override
    public OnmsAccessPointCollection call() throws IOException {
        OnmsAccessPointCollection apsUp = new OnmsAccessPointCollection();
        InetAddress ipaddr = this.m_iface.getIpAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new IllegalStateException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        this.log().debug("poll: setting SNMP peer attribute for interface " + hostAddress);
        String oid = ParameterMap.getKeyedString(this.m_parameters, (String)"oid", null);
        if (oid == null) {
            throw new IllegalStateException("oid parameter is not set.");
        }
        agentConfig.hashCode();
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(this.m_parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(this.m_parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(this.m_parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(this.m_parameters, (String)"port", (int)agentConfig.getPort()));
        if (this.log().isDebugEnabled()) {
            this.log().debug("TableStrategy.poll: SnmpAgentConfig address= " + agentConfig);
        }
        try {
            SnmpObjId snmpObjectId = SnmpObjId.get((String)oid);
            Map map = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"AccessPointMonitor::TableStrategy", (SnmpObjId)snmpObjectId);
            if (map.size() <= 0) {
                throw new IOException("No entries found in table (possible timeout).");
            }
            for (Map.Entry entry : map.entrySet()) {
                SnmpValue value = (SnmpValue)entry.getValue();
                String physAddr = TableStrategy.getPhysAddrFromValue(value);
                this.log().debug("AP at value '" + value.toHexString() + "' with MAC '" + physAddr + "' is considered to be ONLINE on controller '" + this.m_iface.getIpAddress() + "'");
                OnmsAccessPoint ap = this.m_accessPointDao.findByPhysAddr(physAddr);
                if (ap != null) {
                    if (ap.getPollingPackage().compareToIgnoreCase(this.getPackage().getName()) == 0) {
                        ap.setControllerIpAddress(ipaddr);
                        apsUp.add(ap);
                        continue;
                    }
                    this.log().info("AP with MAC '" + physAddr + "' is in a different package.");
                    continue;
                }
                this.log().info("No matching AP in database for value '" + value.toHexString() + "'.");
            }
        }
        catch (InterruptedException e) {
            this.log().error("Interrupted while polling " + hostAddress, (Throwable)e);
        }
        return apsUp;
    }

    public static String getPhysAddrFromValue(SnmpValue value) {
        String hexString = value.toHexString();
        if (hexString.length() != 12) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 12; i += 2) {
            sb.append(hexString.substring(i, i + 2));
            if (i >= 10) continue;
            sb.append(':');
        }
        return sb.toString().toUpperCase();
    }

    @Override
    public void setInterfaceToPoll(OnmsIpInterface interfaceToPoll) {
        this.m_iface = interfaceToPoll;
    }

    @Override
    public OnmsIpInterface getInterfaceToPoll() {
        return this.m_iface;
    }

    @Override
    public void setPackage(Package pkg) {
        this.m_package = pkg;
    }

    @Override
    public Package getPackage() {
        return this.m_package;
    }

    @Override
    public void setPropertyMap(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    @Override
    public Map<String, String> getPropertyMap() {
        return this.m_parameters;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void setAccessPointDao(AccessPointDao accessPointDao) {
        this.m_accessPointDao = accessPointDao;
    }

    @Override
    public AccessPointDao getAccessPointDao() {
        return this.m_accessPointDao;
    }
}

