/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.rt;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.rt.RTTicket;
import org.opennms.netmgt.rt.ReadOnlyRtConfigDao;
import org.opennms.netmgt.rt.RequestTracker;
import org.opennms.netmgt.rt.RequestTrackerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(RtTicketerPlugin.class);
    private static Pattern m_tagPattern = Pattern.compile("<[^>]*>");
    private RequestTracker m_requestTracker;
    private String m_queue;
    private String m_requestor;
    private String m_openStatus;
    private String m_closedStatus;
    private String m_cancelledStatus;
    private List<String> m_validOpenStatus;
    private List<String> m_validClosedStatus;
    private List<String> m_validCancelledStatus;

    public RtTicketerPlugin() {
        ReadOnlyRtConfigDao dao = new ReadOnlyRtConfigDao();
        this.m_openStatus = dao.getOpenStatus();
        this.m_closedStatus = dao.getClosedStatus();
        this.m_cancelledStatus = dao.getCancelledStatus();
        this.m_validOpenStatus = dao.getValidOpenStatus();
        this.m_validClosedStatus = dao.getValidClosedStatus();
        this.m_validCancelledStatus = dao.getValidCancelledStatus();
        this.m_queue = dao.getQueue();
        this.m_requestor = dao.getRequestor();
        this.m_requestTracker = new RequestTracker(dao.getBaseURL(), dao.getUsername(), dao.getPassword(), dao.getTimeout(), dao.getRetry(), dao.getUseSystemProxy());
    }

    public Ticket get(String ticketId) throws PluginException {
        Ticket ticket = null;
        RTTicket rtt = null;
        try {
            rtt = this.m_requestTracker.getTicket(Long.valueOf(ticketId), false);
        }
        catch (RequestTrackerException e) {
            throw new PluginException((Throwable)e);
        }
        if (rtt == null) {
            throw new PluginException("could not find ticket in RT for Ticket: " + ticketId);
        }
        ticket = new Ticket();
        ticket.setState(this.rtToOpenNMSState(rtt.getStatus()));
        ticket.setId(rtt.getId().toString());
        ticket.setUser(StringUtils.join((Collection)rtt.getRequestors(), (String)", "));
        ticket.setSummary(rtt.getSubject());
        ticket.setDetails(rtt.getText());
        return ticket;
    }

    public void saveOrUpdate(Ticket newTicket) throws PluginException {
        block7: {
            Ticket currentTicket = null;
            try {
                if (newTicket.getId() == null) {
                    LOG.debug("TicketId is null creating a new ticket");
                    RTTicket ticket = this.rtTicketFromTicket(newTicket);
                    Long rtTicketNumber = null;
                    try {
                        rtTicketNumber = this.m_requestTracker.createTicket(ticket);
                    }
                    catch (Exception e) {
                        throw new PluginException((Throwable)e);
                    }
                    if (rtTicketNumber == null) {
                        throw new PluginException("Received no ticket number from RT");
                    }
                    String newTicketID = rtTicketNumber.toString();
                    newTicket.setId(newTicketID);
                    LOG.debug("created new ticket: {}", (Object)newTicket.getId());
                    break block7;
                }
                currentTicket = this.get(newTicket.getId());
                LOG.debug("updating existing ticket: {}", (Object)currentTicket.getId());
                if (currentTicket.getState() != newTicket.getState()) {
                    this.updateRtStatus(newTicket);
                }
            }
            catch (PluginException e) {
                LOG.error("Failed to create or update RT ticket", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateRtStatus(Ticket ticket) throws PluginException {
        try {
            this.m_requestTracker.updateTicket(Long.valueOf(ticket.getId()), "Status: " + this.openNMSToRTState(ticket.getState()));
        }
        catch (Exception e) {
            LOG.warn("Error updating ticket {} to state {}", new Object[]{ticket.getId(), ticket.getState(), e});
        }
    }

    private RTTicket rtTicketFromTicket(Ticket ticket) {
        RTTicket rtt = new RTTicket();
        String id = ticket.getId();
        if (id != null && id.length() > 0) {
            rtt.setId(Long.valueOf(id));
        }
        rtt.setQueue(this.m_queue);
        rtt.setRequestor(this.m_requestor);
        if (ticket.getSummary() != null) {
            rtt.setSubject(ticket.getSummary());
        }
        if (ticket.getDetails() != null) {
            rtt.setText(m_tagPattern.matcher(ticket.getDetails()).replaceAll(""));
        }
        rtt.setStatus(this.openNMSToRTState(ticket.getState()));
        return rtt;
    }

    public String openNMSToRTState(Ticket.State state) {
        String rtStatus;
        LOG.debug("getting RT status from OpenNMS State {}", (Object)state);
        switch (state) {
            case OPEN: {
                rtStatus = this.m_openStatus;
                LOG.debug("OpenNMS Status OPEN matched rt status {}", (Object)rtStatus);
                break;
            }
            case CLOSED: {
                rtStatus = this.m_closedStatus;
                LOG.debug("OpenNMS Status CLOSED matched rt status {}", (Object)rtStatus);
                break;
            }
            case CANCELLED: {
                rtStatus = this.m_cancelledStatus;
                LOG.debug("OpenNMS Status CANCELLED matched rt status {}", (Object)rtStatus);
                break;
            }
            default: {
                LOG.debug("No valid OpenNMS state on ticket");
                rtStatus = this.m_openStatus;
            }
        }
        LOG.debug("OpenNMS state was {}, setting RT status to {}", (Object)state, (Object)rtStatus);
        return rtStatus;
    }

    public Ticket.State rtToOpenNMSState(String rtStatus) {
        if (this.m_validOpenStatus.contains(rtStatus)) {
            LOG.debug("RT status {} matched OpenNMS state Open", (Object)rtStatus);
            return Ticket.State.OPEN;
        }
        if (this.m_validClosedStatus.contains(rtStatus)) {
            LOG.debug("RT status {} matched OpenNMS state Closed", (Object)rtStatus);
            return Ticket.State.CLOSED;
        }
        if (this.m_validCancelledStatus.contains(rtStatus)) {
            LOG.debug("RT status {} matched OpenNMS state Cancelled", (Object)rtStatus);
            return Ticket.State.CANCELLED;
        }
        return Ticket.State.OPEN;
    }

    public void setUser(String user) {
        this.m_requestTracker.setUsername(user);
    }

    public void setPassword(String password) {
        this.m_requestTracker.setPassword(password);
    }
}

