/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.rt;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.rt.RTTicket;
import org.opennms.netmgt.rt.ReadOnlyRtConfigDao;
import org.opennms.netmgt.rt.RequestTracker;
import org.opennms.netmgt.rt.RequestTrackerException;

public class RtTicketerPlugin
implements Plugin {
    private static Pattern m_tagPattern = Pattern.compile("<[^>]*>");
    private RequestTracker m_requestTracker;
    private String m_queue;
    private String m_requestor;
    private String m_openStatus;
    private String m_closedStatus;
    private String m_cancelledStatus;
    private List<Integer> m_validOpenStatus;
    private List<String> m_validClosedStatus;
    private List<String> m_validCancelledStatus;

    public RtTicketerPlugin() {
        ReadOnlyRtConfigDao dao = new ReadOnlyRtConfigDao();
        this.m_openStatus = dao.getOpenStatus();
        this.m_closedStatus = dao.getClosedStatus();
        this.m_cancelledStatus = dao.getCancelledStatus();
        this.m_validOpenStatus = dao.getValidOpenStatus();
        this.m_validClosedStatus = dao.getValidClosedStatus();
        this.m_validCancelledStatus = dao.getValidCancelledStatus();
        this.m_queue = dao.getQueue();
        this.m_requestor = dao.getRequestor();
        this.m_requestTracker = new RequestTracker(dao.getBaseURL(), dao.getUsername(), dao.getPassword(), dao.getTimeout(), dao.getRetry());
    }

    public Ticket get(String ticketId) throws PluginException {
        Ticket ticket = null;
        RTTicket rtt = null;
        try {
            rtt = this.m_requestTracker.getTicket(Long.valueOf(ticketId), false);
        }
        catch (RequestTrackerException e) {
            throw new PluginException((Throwable)e);
        }
        if (rtt == null) {
            throw new PluginException("could not find ticket in RT for Ticket: " + ticketId);
        }
        ticket = new Ticket();
        ticket.setState(this.rtToOpenNMSState(rtt.getStatus()));
        ticket.setId(rtt.getId().toString());
        ticket.setUser(StringUtils.join((Collection)rtt.getRequestors(), (String)", "));
        ticket.setSummary(rtt.getSubject());
        ticket.setDetails(rtt.getText());
        return ticket;
    }

    public void saveOrUpdate(Ticket newTicket) throws PluginException {
        block7: {
            Ticket currentTicket = null;
            try {
                if (newTicket.getId() == null) {
                    LogUtils.debugf((Object)this, (String)"TicketId is null creating a new ticket", (Object[])new Object[0]);
                    RTTicket ticket = this.rtTicketFromTicket(newTicket);
                    Long rtTicketNumber = null;
                    try {
                        rtTicketNumber = this.m_requestTracker.createTicket(ticket);
                    }
                    catch (Exception e) {
                        throw new PluginException((Throwable)e);
                    }
                    if (rtTicketNumber == null) {
                        throw new PluginException("Received no ticket number from RT");
                    }
                    String newTicketID = rtTicketNumber.toString();
                    newTicket.setId(newTicketID);
                    LogUtils.debugf((Object)this, (String)"created new ticket: %s", (Object[])new Object[]{newTicket.getId()});
                    break block7;
                }
                currentTicket = this.get(newTicket.getId());
                LogUtils.debugf((Object)this, (String)"updating existing ticket: %s", (Object[])new Object[]{currentTicket.getId()});
                if (currentTicket.getState() != newTicket.getState()) {
                    this.updateRtStatus(newTicket);
                }
            }
            catch (PluginException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Failed to create or update RT ticket", (Object[])new Object[0]);
                throw e;
            }
        }
    }

    private void updateRtStatus(Ticket ticket) throws PluginException {
        try {
            this.m_requestTracker.updateTicket(Long.valueOf(ticket.getId()), "Status: " + this.openNMSToRTState(ticket.getState()));
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Error updating ticket %s to state %s", (Object[])new Object[]{ticket.getId(), ticket.getState().toString()});
        }
    }

    private RTTicket rtTicketFromTicket(Ticket ticket) {
        RTTicket rtt = new RTTicket();
        String id = ticket.getId();
        if (id != null && id.length() > 0) {
            rtt.setId(Long.valueOf(id));
        }
        rtt.setQueue(this.m_queue);
        rtt.setRequestor(this.m_requestor);
        if (ticket.getSummary() != null) {
            rtt.setSubject(ticket.getSummary());
        }
        if (ticket.getDetails() != null) {
            rtt.setText(m_tagPattern.matcher(ticket.getDetails()).replaceAll(""));
        }
        rtt.setStatus(this.openNMSToRTState(ticket.getState()));
        return rtt;
    }

    private String openNMSToRTState(Ticket.State state) {
        String rtStatus;
        LogUtils.debugf((Object)this, (String)"getting RT status from OpenNMS State %s", (Object[])new Object[]{state.toString()});
        switch (state) {
            case OPEN: {
                rtStatus = this.m_openStatus;
                LogUtils.debugf((Object)this, (String)"OpenNMS Status OPEN matched rt status %s", (Object[])new Object[]{rtStatus});
                break;
            }
            case CLOSED: {
                rtStatus = this.m_closedStatus;
                LogUtils.debugf((Object)this, (String)"OpenNMS Status CLOSED matched rt status %s", (Object[])new Object[]{rtStatus});
                break;
            }
            case CANCELLED: {
                rtStatus = this.m_cancelledStatus;
                LogUtils.debugf((Object)this, (String)"OpenNMS Status CANCELLED matched rt status %s", (Object[])new Object[]{rtStatus});
                break;
            }
            default: {
                LogUtils.debugf((Object)this, (String)"No valid OpenNMS state on ticket", (Object[])new Object[0]);
                rtStatus = this.m_openStatus;
            }
        }
        LogUtils.debugf((Object)this, (String)"OpenNMS state was %s, setting RT status to %s", (Object[])new Object[]{state.toString(), rtStatus});
        return rtStatus;
    }

    private Ticket.State rtToOpenNMSState(String rtStatus) {
        if (this.m_validOpenStatus.contains(rtStatus)) {
            LogUtils.debugf((Object)this, (String)"RT status %s matched OpenNMS state Open", (Object[])new Object[]{rtStatus});
            return Ticket.State.OPEN;
        }
        if (this.m_validClosedStatus.contains(rtStatus)) {
            LogUtils.debugf((Object)this, (String)"RT status %s matched OpenNMS state Closed", (Object[])new Object[]{rtStatus});
            return Ticket.State.CLOSED;
        }
        if (this.m_validCancelledStatus.contains(rtStatus)) {
            LogUtils.debugf((Object)this, (String)"RT status %s matched OpenNMS state Cancelled", (Object[])new Object[]{rtStatus});
            return Ticket.State.CANCELLED;
        }
        return Ticket.State.OPEN;
    }

    public void setUser(String user) {
        this.m_requestTracker.setUser(user);
    }

    public void setPassword(String password) {
        this.m_requestTracker.setPassword(password);
    }
}

