/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.remedy;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.integration.remedy.ticketservice.AuthenticationInfo;
import org.opennms.integration.remedy.ticketservice.CreateInputMap;
import org.opennms.integration.remedy.ticketservice.GetInputMap;
import org.opennms.integration.remedy.ticketservice.GetOutputMap;
import org.opennms.integration.remedy.ticketservice.HPD_IncidentInterface_Create_WSPortTypePortType;
import org.opennms.integration.remedy.ticketservice.HPD_IncidentInterface_Create_WSServiceLocator;
import org.opennms.integration.remedy.ticketservice.HPD_IncidentInterface_WSPortTypePortType;
import org.opennms.integration.remedy.ticketservice.HPD_IncidentInterface_WSServiceLocator;
import org.opennms.integration.remedy.ticketservice.ImpactType;
import org.opennms.integration.remedy.ticketservice.Reported_SourceType;
import org.opennms.integration.remedy.ticketservice.Service_TypeType;
import org.opennms.integration.remedy.ticketservice.SetInputMap;
import org.opennms.integration.remedy.ticketservice.StatusType;
import org.opennms.integration.remedy.ticketservice.Status_ReasonType;
import org.opennms.integration.remedy.ticketservice.UrgencyType;
import org.opennms.integration.remedy.ticketservice.VIPType;
import org.opennms.integration.remedy.ticketservice.Work_Info_SourceType;
import org.opennms.integration.remedy.ticketservice.Work_Info_TypeType;
import org.opennms.integration.remedy.ticketservice.Work_Info_View_AccessType;
import org.opennms.netmgt.ticketer.remedy.DefaultRemedyConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemedyTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(RemedyTicketerPlugin.class);
    private DefaultRemedyConfigDao m_configDao = new DefaultRemedyConfigDao();
    private String m_endpoint = this.m_configDao.getEndPoint();
    private String m_portname = this.m_configDao.getPortName();
    private String m_createendpoint = this.m_configDao.getCreateEndPoint();
    private String m_createportname = this.m_configDao.getCreatePortName();
    private static final String ACTION_CREATE = "CREATE";
    private static final String ACTION_MODIFY = "MODIFY";
    public static final String ATTRIBUTE_NODE_LABEL_ID = "nodelabel";
    private static final String ATTRIBUTE_USER_COMMENT_ID = "remedy.user.comment";
    private static final String ATTRIBUTE_URGENCY_ID = "remedy.urgency";
    private static final String ATTRIBUTE_ASSIGNED_GROUP_ID = "remedy.assignedgroup";
    private static final int MAX_SUMMARY_CHARS = 99;

    public Ticket get(String ticketId) throws PluginException {
        Ticket opennmsTicket = new Ticket();
        if (ticketId == null) {
            LOG.error("No Remedy ticketID available in OpenNMS Ticket");
            throw new PluginException("No Remedy ticketID available in OpenNMS Ticket");
        }
        LOG.debug("get: search ticket with id: {}", (Object)ticketId);
        HPD_IncidentInterface_WSPortTypePortType port = this.getTicketServicePort(this.m_portname, this.m_endpoint);
        if (port != null) {
            try {
                GetOutputMap outputmap = port.helpDesk_Query_Service(this.getRemedyInputMap(ticketId), this.getRemedyAuthenticationHeader());
                LOG.info("get: found ticket: {} status: {}", (Object)ticketId, (Object)outputmap.getStatus().getValue());
                LOG.info("get: found ticket: {} urgency: {}", (Object)ticketId, (Object)outputmap.getUrgency().getValue());
                opennmsTicket.setId(ticketId);
                opennmsTicket.setSummary(outputmap.getSummary());
                opennmsTicket.setDetails(outputmap.getNotes());
                opennmsTicket.setState(this.remedyToOpenNMSState(outputmap.getStatus()));
                opennmsTicket.setUser(outputmap.getAssigned_Group());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw new PluginException("Problem getting ticket", (Throwable)e);
            }
        }
        return opennmsTicket;
    }

    private Ticket.State remedyToOpenNMSState(StatusType status) {
        Ticket.State state = Ticket.State.OPEN;
        if (status.toString().equals("Closed") || status.toString().equals("Resolved")) {
            state = Ticket.State.CLOSED;
        } else if (status.toString().equals("Cancelled")) {
            state = Ticket.State.CANCELLED;
        }
        return state;
    }

    public void saveOrUpdate(Ticket newTicket) throws PluginException {
        if (newTicket.getId() == null) {
            this.save(newTicket);
        } else {
            this.update(newTicket);
        }
    }

    private void update(Ticket ticket) throws PluginException {
        HPD_IncidentInterface_WSPortTypePortType port = this.getTicketServicePort(this.m_portname, this.m_endpoint);
        if (port != null) {
            try {
                GetOutputMap remedy = port.helpDesk_Query_Service(this.getRemedyInputMap(ticket.getId()), this.getRemedyAuthenticationHeader());
                if (remedy == null) {
                    LOG.info("update: Remedy: Cannot find incident with incindent_number: {}", (Object)ticket.getId());
                    return;
                }
                if (remedy.getStatus().getValue().equals("Cancelled")) {
                    LOG.info("update: Remedy: Ticket Cancelled. Not updating ticket with incindent_number: {}", (Object)ticket.getId());
                    return;
                }
                if (remedy.getStatus().getValue().equals("Closed")) {
                    LOG.info("update: Remedy: Ticket Closed. Not updating ticket with incindent_number: {}", (Object)ticket.getId());
                    return;
                }
                SetInputMap output = this.getRemedySetInputMap(ticket, remedy);
                LOG.debug("update: Remedy: found urgency: {} - for ticket with incindent_number: {}", (Object)output.getUrgency().getValue(), (Object)ticket.getId());
                output.setUrgency(this.getUrgency(ticket));
                LOG.debug("update: opennms status: {} - for ticket with incindent_number: {}", (Object)ticket.getState(), (Object)ticket.getId());
                LOG.debug("update: Remedy: found status: {} - for ticket with incindent_number: {}", (Object)output.getStatus().getValue(), (Object)ticket.getId());
                Ticket.State outputState = this.remedyToOpenNMSState(output.getStatus());
                LOG.debug("update: Remedy: found opennms status: {} - for ticket with incindent_number: {}", (Object)outputState, (Object)ticket.getId());
                if (ticket.getState() != outputState) {
                    output = this.opennmsToRemedyState(output, ticket.getState());
                }
                port.helpDesk_Modify_Service(output, this.getRemedyAuthenticationHeader());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw new PluginException("Problem creating ticket", (Throwable)e);
            }
        }
    }

    private SetInputMap getRemedySetInputMap(Ticket ticket, GetOutputMap output) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return new SetInputMap(output.getCategorization_Tier_1(), output.getCategorization_Tier_2(), output.getCategorization_Tier_3(), output.getClosure_Manufacturer(), output.getClosure_Product_Category_Tier1(), output.getClosure_Product_Category_Tier2(), output.getClosure_Product_Category_Tier3(), output.getClosure_Product_Model_Version(), output.getClosure_Product_Name(), output.getCompany(), output.getSummary(), output.getNotes(), output.getImpact(), output.getManufacturer(), output.getProduct_Categorization_Tier_1(), output.getProduct_Categorization_Tier_2(), output.getProduct_Categorization_Tier_3(), output.getProduct_Model_Version(), output.getProduct_Name(), output.getReported_Source(), output.getResolution(), output.getResolution_Category(), output.getResolution_Category_Tier_2(), output.getResolution_Category_Tier_3(), "", output.getService_Type(), output.getStatus(), output.getUrgency(), ACTION_MODIFY, "", "", Work_Info_TypeType.value10, cal, Work_Info_SourceType.value1, VIPType.No, Work_Info_View_AccessType.Public, ticket.getId(), output.getStatus_Reason(), output.getServiceCI(), output.getServiceCI_ReconID(), output.getHPD_CI(), output.getHPD_CI_ReconID(), output.getHPD_CI_FormName(), output.getZ1D_CI_FormName(), "", new byte[0], 0);
    }

    private UrgencyType getUrgency(Ticket ticket) {
        UrgencyType urgency;
        try {
            urgency = ticket.getAttribute(ATTRIBUTE_URGENCY_ID) != null ? UrgencyType.fromValue(ticket.getAttribute(ATTRIBUTE_URGENCY_ID)) : UrgencyType.fromValue(this.m_configDao.getUrgency());
        }
        catch (IllegalArgumentException e) {
            return UrgencyType.value4;
        }
        return urgency;
    }

    private String getAssignedGroup(Ticket ticket) {
        if (ticket.getAttribute(ATTRIBUTE_ASSIGNED_GROUP_ID) != null) {
            for (String group : this.m_configDao.getTargetGroups()) {
                if (!group.equals(ticket.getAttribute(ATTRIBUTE_ASSIGNED_GROUP_ID))) continue;
                return this.m_configDao.getAssignedGroup(group);
            }
        }
        return this.m_configDao.getAssignedGroup();
    }

    private String getAssignedSupportCompany(Ticket ticket) {
        if (ticket.getAttribute(ATTRIBUTE_ASSIGNED_GROUP_ID) != null) {
            for (String group : this.m_configDao.getTargetGroups()) {
                if (!group.equals(ticket.getAttribute(ATTRIBUTE_ASSIGNED_GROUP_ID))) continue;
                return this.m_configDao.getAssignedSupportCompany(group);
            }
        }
        return this.m_configDao.getAssignedSupportCompany();
    }

    private String getAssignedSupportOrganization(Ticket ticket) {
        if (ticket.getAttribute(ATTRIBUTE_ASSIGNED_GROUP_ID) != null) {
            for (String group : this.m_configDao.getTargetGroups()) {
                if (!group.equals(ticket.getAttribute(ATTRIBUTE_ASSIGNED_GROUP_ID))) continue;
                return this.m_configDao.getAssignedSupportOrganization(group);
            }
        }
        return this.m_configDao.getAssignedSupportOrganization();
    }

    private String getSummary(Ticket ticket) {
        StringBuffer summary = new StringBuffer();
        if (ticket.getAttribute(ATTRIBUTE_NODE_LABEL_ID) != null) {
            summary.append(ticket.getAttribute(ATTRIBUTE_NODE_LABEL_ID));
            summary.append(": OpenNMS: ");
        }
        summary.append(ticket.getSummary());
        if (summary.length() > 99) {
            return summary.substring(0, 98);
        }
        return summary.toString();
    }

    private String getNotes(Ticket ticket) {
        StringBuffer notes = new StringBuffer("OpenNMS generated ticket by user: ");
        notes.append(ticket.getUser());
        notes.append("\n");
        notes.append("\n");
        if (ticket.getAttribute(ATTRIBUTE_USER_COMMENT_ID) != null) {
            notes.append("OpenNMS user comment: ");
            notes.append(ticket.getAttribute(ATTRIBUTE_USER_COMMENT_ID));
            notes.append("\n");
            notes.append("\n");
        }
        notes.append("OpenNMS logmsg: ");
        notes.append(ticket.getSummary());
        notes.append("\n");
        notes.append("\n");
        notes.append("OpenNMS descr: ");
        notes.append(ticket.getDetails());
        return notes.toString();
    }

    private SetInputMap opennmsToRemedyState(SetInputMap inputmap, Ticket.State state) {
        LOG.debug("getting remedy state from OpenNMS State: {}", (Object)state);
        switch (state) {
            case OPEN: {
                inputmap.setStatus(StatusType.fromValue("Pending"));
                inputmap.setStatus_Reason(Status_ReasonType.fromValue(this.m_configDao.getReOpenStatusReason()));
                break;
            }
            case CANCELLED: {
                inputmap.setStatus(StatusType.fromValue("Cancelled"));
                inputmap.setStatus_Reason(Status_ReasonType.fromValue(this.m_configDao.getCancelledStatusReason()));
                break;
            }
            case CLOSED: {
                inputmap.setStatus(StatusType.fromValue("Resolved"));
                inputmap.setStatus_Reason(Status_ReasonType.fromValue(this.m_configDao.getResolvedStatusReason()));
                inputmap.setResolution(this.m_configDao.getResolution());
                break;
            }
            default: {
                LOG.debug("No valid OpenNMS state on ticket skipping status change");
            }
        }
        LOG.debug("OpenNMS state was        {}", (Object)state);
        LOG.debug("setting Remedy state ID to {}", (Object)inputmap.getStatus().getValue());
        return inputmap;
    }

    private GetInputMap getRemedyInputMap(String ticketId) {
        GetInputMap parameters = new GetInputMap();
        parameters.setIncident_Number(ticketId);
        return parameters;
    }

    private AuthenticationInfo getRemedyAuthenticationHeader() {
        String timezone;
        String locale;
        AuthenticationInfo request_header = new AuthenticationInfo();
        request_header.setUserName(this.m_configDao.getUserName());
        request_header.setPassword(this.m_configDao.getPassword());
        String authentication = this.m_configDao.getAuthentication();
        if (authentication != null) {
            request_header.setAuthentication(authentication);
        }
        if ((locale = this.m_configDao.getLocale()) != null) {
            request_header.setLocale(locale);
        }
        if ((timezone = this.m_configDao.getTimeZone()) != null) {
            request_header.setTimeZone(timezone);
        }
        return request_header;
    }

    private CreateInputMap getRemedyCreateInputMap(Ticket newTicket) {
        CreateInputMap createInputMap = new CreateInputMap();
        createInputMap.setSummary(this.getSummary(newTicket));
        createInputMap.setNotes(this.getNotes(newTicket));
        createInputMap.setFirst_Name(this.m_configDao.getFirstName());
        createInputMap.setLast_Name(this.m_configDao.getLastName());
        createInputMap.setServiceCI(this.m_configDao.getServiceCI());
        createInputMap.setServiceCI_ReconID(this.m_configDao.getServiceCIReconID());
        createInputMap.setImpact(ImpactType.fromValue(this.m_configDao.getImpact()));
        createInputMap.setReported_Source(Reported_SourceType.fromValue(this.m_configDao.getReportedSource()));
        createInputMap.setService_Type(Service_TypeType.fromValue(this.m_configDao.getServiceType()));
        createInputMap.setUrgency(this.getUrgency(newTicket));
        createInputMap.setStatus(StatusType.value1);
        createInputMap.setAction(ACTION_CREATE);
        createInputMap.setCategorization_Tier_1(this.m_configDao.getCategorizationtier1());
        createInputMap.setCategorization_Tier_2(this.m_configDao.getCategorizationtier2());
        createInputMap.setCategorization_Tier_3(this.m_configDao.getCategorizationtier3());
        createInputMap.setAssigned_Group(this.getAssignedGroup(newTicket));
        createInputMap.setAssigned_Support_Company(this.getAssignedSupportCompany(newTicket));
        createInputMap.setAssigned_Support_Organization(this.getAssignedSupportOrganization(newTicket));
        return createInputMap;
    }

    private void save(Ticket newTicket) throws PluginException {
        HPD_IncidentInterface_Create_WSPortTypePortType port = this.getCreateTicketServicePort(this.m_createportname, this.m_createendpoint);
        try {
            String incident_number = port.helpDesk_Submit_Service(this.getRemedyAuthenticationHeader(), this.getRemedyCreateInputMap(newTicket)).getIncident_Number();
            LOG.debug("created new remedy ticket with reported incident number: {}", (Object)incident_number);
            newTicket.setId(incident_number);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new PluginException("Problem saving ticket", (Throwable)e);
        }
    }

    private HPD_IncidentInterface_WSPortTypePortType getTicketServicePort(String portname, String endpoint) throws PluginException {
        HPD_IncidentInterface_WSServiceLocator service = new HPD_IncidentInterface_WSServiceLocator();
        HPD_IncidentInterface_WSPortTypePortType port = null;
        try {
            service.setEndpointAddress(portname, endpoint);
            port = service.getHPD_IncidentInterface_WSPortTypeSoap();
        }
        catch (ServiceException e) {
            LOG.error("Failed initialzing Remedy TicketServicePort", (Throwable)e);
            throw new PluginException("Failed initialzing Remedy TicketServicePort", (Throwable)e);
        }
        return port;
    }

    private HPD_IncidentInterface_Create_WSPortTypePortType getCreateTicketServicePort(String portname, String endpoint) throws PluginException {
        HPD_IncidentInterface_Create_WSServiceLocator service = new HPD_IncidentInterface_Create_WSServiceLocator();
        HPD_IncidentInterface_Create_WSPortTypePortType port = null;
        try {
            service.setEndpointAddress(portname, endpoint);
            port = service.getHPD_IncidentInterface_Create_WSPortTypeSoap();
        }
        catch (ServiceException e) {
            LOG.error("Failed initialzing Remedy TicketServicePort", (Throwable)e);
            throw new PluginException("Failed initialzing Remedy TicketServicePort", (Throwable)e);
        }
        return port;
    }
}

