/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.remedy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemedyConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRemedyConfigDao.class);
    Configuration m_config = null;

    private Configuration getProperties() {
        if (this.m_config != null) {
            return this.m_config;
        }
        String propsFile = new String(System.getProperty("opennms.home") + "/etc/remedy.properties");
        LOG.debug("loading properties from: {}", (Object)propsFile);
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(propsFile);
        }
        catch (ConfigurationException e) {
            LOG.debug("Unable to load properties from {}", (Object)propsFile, (Object)e);
        }
        this.m_config = config;
        return config;
    }

    public String getUserName() {
        return this.getProperties().getString("remedy.username");
    }

    String getPassword() {
        return this.getProperties().getString("remedy.password");
    }

    String getAuthentication() {
        return this.getProperties().getString("remedy.authentication");
    }

    String getLocale() {
        return this.getProperties().getString("remedy.locale");
    }

    String getTimeZone() {
        return this.getProperties().getString("remedy.timezone");
    }

    String getEndPoint() {
        return this.getProperties().getString("remedy.endpoint");
    }

    String getPortName() {
        return this.getProperties().getString("remedy.portname");
    }

    String getCreateEndPoint() {
        return this.getProperties().getString("remedy.createendpoint");
    }

    String getCreatePortName() {
        return this.getProperties().getString("remedy.createportname");
    }

    List<String> getTargetGroups() {
        ArrayList<String> targetGroups = new ArrayList<String>();
        if (this.getProperties().containsKey("remedy.targetgroups")) {
            for (String group : this.getProperties().getString("remedy.targetgroups").split(":")) {
                targetGroups.add(group);
            }
        }
        return targetGroups;
    }

    String getAssignedGroup() {
        return this.getProperties().getString("remedy.assignedgroup");
    }

    String getAssignedGroup(String targetGroup) {
        if (this.getProperties().containsKey("remedy.assignedgroup." + targetGroup)) {
            return this.getProperties().getString("remedy.assignedgroup." + targetGroup);
        }
        return this.getAssignedGroup();
    }

    String getFirstName() {
        return this.getProperties().getString("remedy.firstname");
    }

    String getLastName() {
        return this.getProperties().getString("remedy.lastname");
    }

    String getServiceCI() {
        return this.getProperties().getString("remedy.serviceCI");
    }

    String getServiceCIReconID() {
        return this.getProperties().getString("remedy.serviceCIReconID");
    }

    String getAssignedSupportCompany() {
        return this.getProperties().getString("remedy.assignedsupportcompany");
    }

    String getAssignedSupportCompany(String targetGroup) {
        if (this.getProperties().containsKey("remedy.assignedsupportcompany." + targetGroup)) {
            return this.getProperties().getString("remedy.assignedsupportcompany." + targetGroup);
        }
        return this.getAssignedSupportCompany();
    }

    String getAssignedSupportOrganization() {
        return this.getProperties().getString("remedy.assignedsupportorganization");
    }

    String getAssignedSupportOrganization(String targetGroup) {
        if (this.getProperties().containsKey("remedy.assignedsupportorganization." + targetGroup)) {
            return this.getProperties().getString("remedy.assignedsupportorganization." + targetGroup);
        }
        return this.getAssignedSupportOrganization();
    }

    String getCategorizationtier1() {
        return this.getProperties().getString("remedy.categorizationtier1");
    }

    String getCategorizationtier2() {
        return this.getProperties().getString("remedy.categorizationtier2");
    }

    String getCategorizationtier3() {
        return this.getProperties().getString("remedy.categorizationtier3");
    }

    String getServiceType() {
        return this.getProperties().getString("remedy.serviceType");
    }

    String getReportedSource() {
        return this.getProperties().getString("remedy.reportedSource");
    }

    String getImpact() {
        return this.getProperties().getString("remedy.impact");
    }

    String getUrgency() {
        return this.getProperties().getString("remedy.urgency");
    }

    String getResolution() {
        return this.getProperties().getString("remedy.resolution");
    }

    String getReOpenStatusReason() {
        return this.getProperties().getString("remedy.reason.reopen");
    }

    String getResolvedStatusReason() {
        return this.getProperties().getString("remedy.reason.resolved");
    }

    String getCancelledStatusReason() {
        return this.getProperties().getString("remedy.reason.cancelled");
    }
}

