/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.otrs;

import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.integration.otrs.ticketservice.Article;
import org.opennms.integration.otrs.ticketservice.ArticleCore;
import org.opennms.integration.otrs.ticketservice.Credentials;
import org.opennms.integration.otrs.ticketservice.TicketCore;
import org.opennms.integration.otrs.ticketservice.TicketIDAndNumber;
import org.opennms.integration.otrs.ticketservice.TicketServiceLocator;
import org.opennms.integration.otrs.ticketservice.TicketServicePort_PortType;
import org.opennms.integration.otrs.ticketservice.TicketStateUpdate;
import org.opennms.integration.otrs.ticketservice.TicketWithArticles;
import org.opennms.netmgt.ticketer.otrs.common.DefaultOtrsConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtrsTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(OtrsTicketerPlugin.class);
    private DefaultOtrsConfigDao m_configDao = new DefaultOtrsConfigDao();
    private String m_endpoint = this.m_configDao.getEndpoint();

    public Ticket get(String ticketId) throws PluginException {
        TicketWithArticles ticketWithArticles = null;
        Ticket opennmsTicket = new Ticket();
        if (ticketId == null) {
            LOG.error("No OTRS ticketID available in OpenNMS Ticket");
            throw new PluginException("No OTRS ticketID available in OpenNMS Ticket");
        }
        TicketServicePort_PortType port = this.getTicketServicePort(this.m_endpoint);
        if (port != null) {
            long otrsTicketNumber = Long.parseLong(ticketId.trim());
            Credentials creds = new Credentials();
            creds.setUser(this.m_configDao.getUserName());
            creds.setPass(this.m_configDao.getPassword());
            try {
                ticketWithArticles = port.getByNumber(otrsTicketNumber, creds);
            }
            catch (RemoteException e) {
                LOG.error("Failed to retrieve OTRS ticket", (Throwable)e);
                throw new PluginException("Failed to retrieve OTRS ticket");
            }
        }
        LOG.debug("Adding Ticket details from OTRS ticket # {}", (Object)ticketWithArticles.getTicket().getTicketNumber());
        opennmsTicket.setId(ticketWithArticles.getTicket().getTicketNumber().toString());
        opennmsTicket.setSummary(ticketWithArticles.getTicket().getTitle());
        opennmsTicket.setUser(ticketWithArticles.getTicket().getOwner());
        opennmsTicket.setState(this.otrsToOpenNMSState(ticketWithArticles.getTicket().getStateID()));
        LOG.debug("Retrieved ticket state : {}", (Object)this.otrsToOpenNMSState(ticketWithArticles.getTicket().getStateID()));
        String opennmsTicketDetails = "";
        for (Article article : ticketWithArticles.getArticles()) {
            LOG.debug("Adding Article details from OTRS article ID {}", (Object)article.getArticleID());
            opennmsTicketDetails = opennmsTicketDetails + "\n" + "From:    " + article.getFrom() + "\n" + "Subject: " + article.getSubject() + "\n" + "Body:\n" + article.getBody() + "\n";
        }
        opennmsTicket.setDetails(opennmsTicketDetails);
        return opennmsTicket;
    }

    public void saveOrUpdate(Ticket newTicket) throws PluginException {
        TicketIDAndNumber idAndNumber = null;
        TicketServicePort_PortType port = this.getTicketServicePort(this.m_endpoint);
        Ticket currentTicket = null;
        Credentials creds = new Credentials();
        creds.setUser(this.m_configDao.getUserName());
        creds.setPass(this.m_configDao.getPassword());
        try {
            if (newTicket.getId() == null) {
                idAndNumber = this.newOTRSTicket(newTicket, port, creds);
                newTicket.setId(String.valueOf(idAndNumber.getTicketNumber()));
                LOG.debug("created new ticket: {}", (Object)newTicket.getId());
                this.newOTRSArticle(idAndNumber.getTicketNumber(), newTicket, port, creds);
            } else {
                currentTicket = this.get(newTicket.getId());
                LOG.debug("updating existing ticket : {}", (Object)currentTicket.getId());
                if (currentTicket.getState() != newTicket.getState()) {
                    this.updateOTRSState(newTicket, port, creds);
                    this.updateOTRSArticle(Long.parseLong(currentTicket.getId()), newTicket, port, creds);
                }
            }
        }
        catch (RemoteException e) {
            LOG.error("Failed to create or update OTRS ticket", (Throwable)e);
            throw new PluginException("Failed to create or update OTRS ticket");
        }
    }

    private void updateOTRSState(Ticket ticket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        Integer otrsStateId = this.openNMSToOTRSState(ticket.getState());
        TicketStateUpdate stateUpdate = new TicketStateUpdate();
        stateUpdate.setStateID(otrsStateId);
        stateUpdate.setTicketNumber(Long.parseLong(ticket.getId()));
        stateUpdate.setUser(this.m_configDao.getDefaultUser());
        LOG.debug("Updating ticket with new state");
        LOG.debug("Ticket ID:     {}", (Object)ticket.getId());
        LOG.debug("OpenNMS State: {}", (Object)ticket.getState().toString());
        LOG.debug("OTRS state:    {}", (Object)otrsStateId.toString());
        port.ticketStateUpdate(stateUpdate, creds);
    }

    private TicketIDAndNumber newOTRSTicket(Ticket newTicket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        TicketIDAndNumber idAndNumber = null;
        TicketCore newOtrsTicket = new TicketCore();
        newOtrsTicket.setTitle(newTicket.getSummary().replaceAll("\\<.*?\\>", ""));
        newOtrsTicket.setUser(this.m_configDao.getDefaultUser());
        newOtrsTicket.setStateID(this.openNMSToOTRSState(newTicket.getState()));
        newOtrsTicket.setQueue(this.m_configDao.getQueue());
        newOtrsTicket.setPriority(this.m_configDao.getPriority());
        newOtrsTicket.setLock(this.m_configDao.getLock());
        newOtrsTicket.setOwnerID(this.m_configDao.getOwnerID());
        idAndNumber = port.ticketCreate(newOtrsTicket, creds);
        return idAndNumber;
    }

    private void newOTRSArticle(Long otrsTicketNumber, Ticket newTicket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        ArticleCore newOtrsArticle = new ArticleCore();
        LOG.debug("Adding a new article to ticket: {}", (Object)otrsTicketNumber);
        newOtrsArticle.setBody(newTicket.getDetails());
        newOtrsArticle.setTicketNumber(otrsTicketNumber);
        newOtrsArticle.setFrom(this.m_configDao.getArticleFrom());
        newOtrsArticle.setUser(this.m_configDao.getDefaultUser());
        newOtrsArticle.setSubject(newTicket.getSummary().replaceAll("\\<.*?\\>", ""));
        newOtrsArticle.setArticleType(this.m_configDao.getArticleType());
        newOtrsArticle.setSenderType(this.m_configDao.getArticleSenderType());
        newOtrsArticle.setContentType(this.m_configDao.getArticleContentType());
        newOtrsArticle.setHistoryType(this.m_configDao.getArticleHistoryType());
        newOtrsArticle.setHistoryComment(this.m_configDao.getArticleHistoryComment());
        port.articleCreate(newOtrsArticle, creds);
    }

    private void updateOTRSArticle(Long otrsTicketNumber, Ticket newTicket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        ArticleCore newOtrsArticle = new ArticleCore();
        LOG.debug("Adding a new article to ticket: {}", (Object)otrsTicketNumber);
        switch (newTicket.getState()) {
            case OPEN: {
                newOtrsArticle.setBody(this.m_configDao.getTicketOpenedMessage());
                break;
            }
            case CANCELLED: {
                newOtrsArticle.setBody(this.m_configDao.getTicketCancelledMessage());
                break;
            }
            case CLOSED: {
                newOtrsArticle.setBody(this.m_configDao.getTicketClosedMessage());
                break;
            }
            default: {
                LOG.debug("No valid OpenNMS state on ticket");
                newOtrsArticle.setBody(this.m_configDao.getTicketUpdatedMessage());
            }
        }
        newOtrsArticle.setTicketNumber(otrsTicketNumber);
        newOtrsArticle.setFrom(this.m_configDao.getArticleFrom());
        newOtrsArticle.setUser(this.m_configDao.getDefaultUser());
        newOtrsArticle.setSubject(this.m_configDao.getArticleUpdateSubject());
        newOtrsArticle.setArticleType(this.m_configDao.getArticleType());
        newOtrsArticle.setSenderType(this.m_configDao.getArticleSenderType());
        newOtrsArticle.setContentType(this.m_configDao.getArticleContentType());
        newOtrsArticle.setHistoryType(this.m_configDao.getArticleHistoryType());
        newOtrsArticle.setHistoryComment(this.m_configDao.getArticleHistoryComment());
        port.articleCreate(newOtrsArticle, creds);
    }

    private Integer openNMSToOTRSState(Ticket.State state) {
        Integer otrsStateId;
        LOG.debug("getting otrs state from OpenNMS State {}", (Object)state.toString());
        switch (state) {
            case OPEN: {
                otrsStateId = this.m_configDao.getOpenStateId();
                break;
            }
            case CANCELLED: {
                otrsStateId = this.m_configDao.getCancelledStateId();
                break;
            }
            case CLOSED: {
                otrsStateId = this.m_configDao.getClosedStateId();
                break;
            }
            default: {
                LOG.debug("No valid OpenNMS state on ticket");
                otrsStateId = this.m_configDao.getOpenStateId();
            }
        }
        LOG.debug("OpenNMS state was        {}", (Object)state.toString());
        LOG.debug("setting OTRS state ID to {}", (Object)otrsStateId.toString());
        return otrsStateId;
    }

    private Ticket.State otrsToOpenNMSState(Integer otrsStateId) {
        Ticket.State openNMSState;
        if (this.m_configDao.getValidOpenStateId().contains(otrsStateId)) {
            LOG.debug("OTRS state ID {} matched OpenNMS state Open", (Object)otrsStateId);
            openNMSState = Ticket.State.OPEN;
        } else if (this.m_configDao.getValidClosedStateId().contains(otrsStateId)) {
            LOG.debug("OTRS state ID {} matched OpenNMS state Closed", (Object)otrsStateId);
            openNMSState = Ticket.State.CLOSED;
        } else if (this.m_configDao.getValidCancelledStateId().contains(otrsStateId)) {
            LOG.debug("OTRS state ID {} matched OpenNMS state Cancelled", (Object)otrsStateId);
            openNMSState = Ticket.State.CANCELLED;
        } else {
            LOG.debug("OTRS state ID {} has no matching OpenNMS state", (Object)otrsStateId);
            openNMSState = Ticket.State.OPEN;
        }
        return openNMSState;
    }

    private TicketServicePort_PortType getTicketServicePort(String endpoint) throws PluginException {
        TicketServiceLocator service = new TicketServiceLocator();
        service.setTicketServicePortEndpointAddress(endpoint);
        TicketServicePort_PortType port = null;
        try {
            port = service.getTicketServicePort();
        }
        catch (ServiceException e) {
            LOG.error("Failed initialzing OTRS TicketServicePort", (Throwable)e);
            throw new PluginException("Failed initialzing OTRS TicketServicePort");
        }
        return port;
    }

    public String getEndpoint() {
        return this.m_endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.m_endpoint = endpoint;
    }
}

