/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.otrs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOtrsConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOtrsConfigDao.class);

    private Configuration getProperties() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        String propsFile = null;
        try {
            propsFile = new File(new File(System.getProperty("opennms.home"), "etc"), "otrs.properties").getCanonicalPath();
            LOG.debug("loading properties from: {}", (Object)propsFile);
            config = new PropertiesConfiguration(propsFile);
        }
        catch (ConfigurationException e) {
            LOG.error("Unable to load properties from {}", propsFile, (Object)e);
        }
        catch (IOException e) {
            LOG.error("Exception when trying to find OTRS configuration properties from {}", propsFile, (Object)e);
        }
        return config;
    }

    public String getUserName() {
        return this.getProperties().getString("otrs.username");
    }

    String getPassword() {
        return this.getProperties().getString("otrs.password");
    }

    String getEndpoint() {
        return this.getProperties().getString("otrs.endpoint");
    }

    String getState() {
        return this.getProperties().getString("otrs.state");
    }

    Integer getOwnerID() {
        return this.getProperties().getInteger("otrs.ownerid", Integer.valueOf(1));
    }

    String getPriority() {
        return this.getProperties().getString("otrs.priority");
    }

    String getLock() {
        return this.getProperties().getString("otrs.lock");
    }

    String getQueue() {
        return this.getProperties().getString("otrs.queue");
    }

    String getArticleFrom() {
        return this.getProperties().getString("otrs.articlefrom");
    }

    String getArticleType() {
        return this.getProperties().getString("otrs.articletype");
    }

    String getArticleSenderType() {
        return this.getProperties().getString("otrs.articlesendertype");
    }

    String getArticleContentType() {
        return this.getProperties().getString("otrs.articlecontenttype");
    }

    String getArticleHistoryComment() {
        return this.getProperties().getString("otrs.articlehistorycomment");
    }

    String getArticleHistoryType() {
        return this.getProperties().getString("otrs.articlehistorytype");
    }

    List<Integer> getValidClosedStateId() {
        List closedStateId = this.getProperties().getList("otrs.validclosedstateid");
        return this.stringToInt(closedStateId);
    }

    List<Integer> getValidOpenStateId() {
        List openStateId = this.getProperties().getList("otrs.validopenstateid");
        return this.stringToInt(openStateId);
    }

    List<Integer> getValidCancelledStateId() {
        List cancelledStateId = this.getProperties().getList("otrs.validcancelledstateid");
        return this.stringToInt(cancelledStateId);
    }

    Integer getOpenStateId() {
        return this.getProperties().getInteger("otrs.openstateid", Integer.valueOf(1));
    }

    Integer getClosedStateId() {
        LOG.debug("getting closed state ID: {}", (Object)this.getProperties().getInteger("otrs.closedstateid", Integer.valueOf(2)));
        return this.getProperties().getInteger("otrs.closedstateid", Integer.valueOf(2));
    }

    Integer getCancelledStateId() {
        return this.getProperties().getInteger("otrs.cancelledstateid", Integer.valueOf(5));
    }

    String getDefaultUser() {
        return this.getProperties().getString("otrs.defaultuser");
    }

    private List<Integer> stringToInt(List<String> strings) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (String string : strings) {
            intList.add(Integer.parseInt(string));
        }
        return intList;
    }

    String getTicketOpenedMessage() {
        return this.getProperties().getString("otrs.ticketopenedmessage");
    }

    String getTicketClosedMessage() {
        return this.getProperties().getString("otrs.ticketclosedmessage");
    }

    String getTicketCancelledMessage() {
        return this.getProperties().getString("otrs.ticketcancelledmessage");
    }

    String getTicketUpdatedMessage() {
        return this.getProperties().getString("otrs.ticketupdatedmessage");
    }

    String getArticleUpdateSubject() {
        return this.getProperties().getString("otrs.articleupdatesubject");
    }
}

