
package org.otrs.ticketconnector;

import java.io.Serializable;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.ticketer.otrs31.BigIntegerAdapter;


/**
 * <p>Java class for OTRS_Article complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="OTRS_Article"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;element name="ArticleTypeID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *           &lt;element name="ArticleType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;choice minOccurs="0"&gt;
 *           &lt;element name="SenderTypeID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *           &lt;element name="SenderType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="From" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="Subject" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="Body" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;choice&gt;
 *           &lt;element name="ContentType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *           &lt;sequence minOccurs="0"&gt;
 *             &lt;element name="Charset" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *             &lt;element name="MimeType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *           &lt;/sequence&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="HistoryType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="HistoryComment" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="AutoResponseType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="TimeUnit" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *         &lt;element name="NoAgentNotify" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *         &lt;element name="ForceNotificationToUserID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="ExcludeNotificationToUserID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="ExcludeMuteNotificationToUserID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OTRS_Article", propOrder = {
    "articleTypeID",
    "articleType",
    "senderTypeID",
    "senderType",
    "from",
    "subject",
    "body",
    "contentType",
    "charset",
    "mimeType",
    "historyType",
    "historyComment",
    "autoResponseType",
    "timeUnit",
    "noAgentNotify",
    "forceNotificationToUserID",
    "excludeNotificationToUserID",
    "excludeMuteNotificationToUserID"
})
public class OTRSArticle
    implements Serializable
{

    @XmlElement(name = "ArticleTypeID", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger articleTypeID;
    @XmlElement(name = "ArticleType")
    protected String articleType;
    @XmlElement(name = "SenderTypeID", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger senderTypeID;
    @XmlElement(name = "SenderType")
    protected String senderType;
    @XmlElement(name = "From")
    protected String from;
    @XmlElement(name = "Subject", required = true)
    protected String subject;
    @XmlElement(name = "Body", required = true)
    protected String body;
    @XmlElement(name = "ContentType")
    protected String contentType;
    @XmlElement(name = "Charset")
    protected String charset;
    @XmlElement(name = "MimeType")
    protected String mimeType;
    @XmlElement(name = "HistoryType")
    protected String historyType;
    @XmlElement(name = "HistoryComment")
    protected String historyComment;
    @XmlElement(name = "AutoResponseType")
    protected String autoResponseType;
    @XmlElement(name = "TimeUnit", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger timeUnit;
    @XmlElement(name = "NoAgentNotify", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger noAgentNotify;
    @XmlElement(name = "ForceNotificationToUserID", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger[] forceNotificationToUserID;
    @XmlElement(name = "ExcludeNotificationToUserID", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger[] excludeNotificationToUserID;
    @XmlElement(name = "ExcludeMuteNotificationToUserID", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger[] excludeMuteNotificationToUserID;

    /**
     * Gets the value of the articleTypeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getArticleTypeID() {
        return articleTypeID;
    }

    /**
     * Sets the value of the articleTypeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArticleTypeID(BigInteger value) {
        this.articleTypeID = value;
    }

    /**
     * Gets the value of the articleType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getArticleType() {
        return articleType;
    }

    /**
     * Sets the value of the articleType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArticleType(String value) {
        this.articleType = value;
    }

    /**
     * Gets the value of the senderTypeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getSenderTypeID() {
        return senderTypeID;
    }

    /**
     * Sets the value of the senderTypeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSenderTypeID(BigInteger value) {
        this.senderTypeID = value;
    }

    /**
     * Gets the value of the senderType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSenderType() {
        return senderType;
    }

    /**
     * Sets the value of the senderType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSenderType(String value) {
        this.senderType = value;
    }

    /**
     * Gets the value of the from property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFrom() {
        return from;
    }

    /**
     * Sets the value of the from property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFrom(String value) {
        this.from = value;
    }

    /**
     * Gets the value of the subject property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        return subject;
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    /**
     * Gets the value of the body property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBody() {
        return body;
    }

    /**
     * Sets the value of the body property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBody(String value) {
        this.body = value;
    }

    /**
     * Gets the value of the contentType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContentType() {
        return contentType;
    }

    /**
     * Sets the value of the contentType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setContentType(String value) {
        this.contentType = value;
    }

    /**
     * Gets the value of the charset property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCharset() {
        return charset;
    }

    /**
     * Sets the value of the charset property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCharset(String value) {
        this.charset = value;
    }

    /**
     * Gets the value of the mimeType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * Sets the value of the mimeType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMimeType(String value) {
        this.mimeType = value;
    }

    /**
     * Gets the value of the historyType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHistoryType() {
        return historyType;
    }

    /**
     * Sets the value of the historyType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHistoryType(String value) {
        this.historyType = value;
    }

    /**
     * Gets the value of the historyComment property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHistoryComment() {
        return historyComment;
    }

    /**
     * Sets the value of the historyComment property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHistoryComment(String value) {
        this.historyComment = value;
    }

    /**
     * Gets the value of the autoResponseType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAutoResponseType() {
        return autoResponseType;
    }

    /**
     * Sets the value of the autoResponseType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAutoResponseType(String value) {
        this.autoResponseType = value;
    }

    /**
     * Gets the value of the timeUnit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getTimeUnit() {
        return timeUnit;
    }

    /**
     * Sets the value of the timeUnit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTimeUnit(BigInteger value) {
        this.timeUnit = value;
    }

    /**
     * Gets the value of the noAgentNotify property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getNoAgentNotify() {
        return noAgentNotify;
    }

    /**
     * Sets the value of the noAgentNotify property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNoAgentNotify(BigInteger value) {
        this.noAgentNotify = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link String }
     *     
     */
    public BigInteger[] getForceNotificationToUserID() {
        if (this.forceNotificationToUserID == null) {
            return new BigInteger[ 0 ] ;
        }
        BigInteger[] retVal = new BigInteger[this.forceNotificationToUserID.length] ;
        System.arraycopy(this.forceNotificationToUserID, 0, retVal, 0, this.forceNotificationToUserID.length);
        return (retVal);
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link String }
     *     
     */
    public BigInteger getForceNotificationToUserID(int idx) {
        if (this.forceNotificationToUserID == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.forceNotificationToUserID[idx];
    }

    public int getForceNotificationToUserIDLength() {
        if (this.forceNotificationToUserID == null) {
            return  0;
        }
        return this.forceNotificationToUserID.length;
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link String }
     *     
     */
    public void setForceNotificationToUserID(BigInteger[] values) {
        int len = values.length;
        this.forceNotificationToUserID = ((BigInteger[]) new BigInteger[len] );
        for (int i = 0; (i<len); i ++) {
            this.forceNotificationToUserID[i] = values[i];
        }
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public BigInteger setForceNotificationToUserID(int idx, BigInteger value) {
        return this.forceNotificationToUserID[idx] = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link String }
     *     
     */
    public BigInteger[] getExcludeNotificationToUserID() {
        if (this.excludeNotificationToUserID == null) {
            return new BigInteger[ 0 ] ;
        }
        BigInteger[] retVal = new BigInteger[this.excludeNotificationToUserID.length] ;
        System.arraycopy(this.excludeNotificationToUserID, 0, retVal, 0, this.excludeNotificationToUserID.length);
        return (retVal);
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link String }
     *     
     */
    public BigInteger getExcludeNotificationToUserID(int idx) {
        if (this.excludeNotificationToUserID == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.excludeNotificationToUserID[idx];
    }

    public int getExcludeNotificationToUserIDLength() {
        if (this.excludeNotificationToUserID == null) {
            return  0;
        }
        return this.excludeNotificationToUserID.length;
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link String }
     *     
     */
    public void setExcludeNotificationToUserID(BigInteger[] values) {
        int len = values.length;
        this.excludeNotificationToUserID = ((BigInteger[]) new BigInteger[len] );
        for (int i = 0; (i<len); i ++) {
            this.excludeNotificationToUserID[i] = values[i];
        }
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public BigInteger setExcludeNotificationToUserID(int idx, BigInteger value) {
        return this.excludeNotificationToUserID[idx] = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link String }
     *     
     */
    public BigInteger[] getExcludeMuteNotificationToUserID() {
        if (this.excludeMuteNotificationToUserID == null) {
            return new BigInteger[ 0 ] ;
        }
        BigInteger[] retVal = new BigInteger[this.excludeMuteNotificationToUserID.length] ;
        System.arraycopy(this.excludeMuteNotificationToUserID, 0, retVal, 0, this.excludeMuteNotificationToUserID.length);
        return (retVal);
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link String }
     *     
     */
    public BigInteger getExcludeMuteNotificationToUserID(int idx) {
        if (this.excludeMuteNotificationToUserID == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.excludeMuteNotificationToUserID[idx];
    }

    public int getExcludeMuteNotificationToUserIDLength() {
        if (this.excludeMuteNotificationToUserID == null) {
            return  0;
        }
        return this.excludeMuteNotificationToUserID.length;
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link String }
     *     
     */
    public void setExcludeMuteNotificationToUserID(BigInteger[] values) {
        int len = values.length;
        this.excludeMuteNotificationToUserID = ((BigInteger[]) new BigInteger[len] );
        for (int i = 0; (i<len); i ++) {
            this.excludeMuteNotificationToUserID[i] = values[i];
        }
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public BigInteger setExcludeMuteNotificationToUserID(int idx, BigInteger value) {
        return this.excludeMuteNotificationToUserID[idx] = value;
    }

}
