
package org.otrs.ticketconnector;

import java.io.Serializable;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.ticketer.otrs31.BigIntegerAdapter;


/**
 * <p>Java class for OTRS_TicketUpdate complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="OTRS_TicketUpdate"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice&gt;
 *           &lt;element name="UserLogin" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *           &lt;element name="CustomerUserLogin" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *           &lt;element name="SessionID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="Password" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;choice&gt;
 *           &lt;element name="TicketID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger"/&gt;
 *           &lt;element name="TicketNumber" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="Ticket" type="{http://www.otrs.org/TicketConnector/}OTRS_TicketUpdate_Ticket" minOccurs="0"/&gt;
 *         &lt;element name="Article" type="{http://www.otrs.org/TicketConnector/}OTRS_Article" minOccurs="0"/&gt;
 *         &lt;element name="DynamicField" type="{http://www.otrs.org/TicketConnector/}OTRS_DynamicField" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="Attachment" type="{http://www.otrs.org/TicketConnector/}OTRS_Attachment" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OTRS_TicketUpdate", propOrder = {
    "userLogin",
    "customerUserLogin",
    "sessionID",
    "password",
    "ticketID",
    "ticketNumber",
    "ticket",
    "article",
    "dynamicField",
    "attachment"
})
public class OTRSTicketUpdate
    implements Serializable
{

    @XmlElement(name = "UserLogin")
    protected String userLogin;
    @XmlElement(name = "CustomerUserLogin")
    protected String customerUserLogin;
    @XmlElement(name = "SessionID")
    protected String sessionID;
    @XmlElement(name = "Password")
    protected String password;
    @XmlElement(name = "TicketID", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger ticketID;
    @XmlElement(name = "TicketNumber")
    protected String ticketNumber;
    @XmlElement(name = "Ticket")
    protected OTRSTicketUpdateTicket ticket;
    @XmlElement(name = "Article")
    protected OTRSArticle article;
    @XmlElement(name = "DynamicField")
    protected org.otrs.ticketconnector.OTRSDynamicField[] dynamicField;
    @XmlElement(name = "Attachment")
    protected org.otrs.ticketconnector.OTRSAttachment[] attachment;

    /**
     * Gets the value of the userLogin property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserLogin() {
        return userLogin;
    }

    /**
     * Sets the value of the userLogin property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUserLogin(String value) {
        this.userLogin = value;
    }

    /**
     * Gets the value of the customerUserLogin property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomerUserLogin() {
        return customerUserLogin;
    }

    /**
     * Sets the value of the customerUserLogin property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomerUserLogin(String value) {
        this.customerUserLogin = value;
    }

    /**
     * Gets the value of the sessionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSessionID() {
        return sessionID;
    }

    /**
     * Sets the value of the sessionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSessionID(String value) {
        this.sessionID = value;
    }

    /**
     * Gets the value of the password property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPassword() {
        return password;
    }

    /**
     * Sets the value of the password property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * Gets the value of the ticketID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getTicketID() {
        return ticketID;
    }

    /**
     * Sets the value of the ticketID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTicketID(BigInteger value) {
        this.ticketID = value;
    }

    /**
     * Gets the value of the ticketNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /**
     * Sets the value of the ticketNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTicketNumber(String value) {
        this.ticketNumber = value;
    }

    /**
     * Gets the value of the ticket property.
     * 
     * @return
     *     possible object is
     *     {@link OTRSTicketUpdateTicket }
     *     
     */
    public OTRSTicketUpdateTicket getTicket() {
        return ticket;
    }

    /**
     * Sets the value of the ticket property.
     * 
     * @param value
     *     allowed object is
     *     {@link OTRSTicketUpdateTicket }
     *     
     */
    public void setTicket(OTRSTicketUpdateTicket value) {
        this.ticket = value;
    }

    /**
     * Gets the value of the article property.
     * 
     * @return
     *     possible object is
     *     {@link OTRSArticle }
     *     
     */
    public OTRSArticle getArticle() {
        return article;
    }

    /**
     * Sets the value of the article property.
     * 
     * @param value
     *     allowed object is
     *     {@link OTRSArticle }
     *     
     */
    public void setArticle(OTRSArticle value) {
        this.article = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link org.otrs.ticketconnector.OTRSDynamicField }
     *     
     */
    public org.otrs.ticketconnector.OTRSDynamicField[] getDynamicField() {
        if (this.dynamicField == null) {
            return new org.otrs.ticketconnector.OTRSDynamicField[ 0 ] ;
        }
        org.otrs.ticketconnector.OTRSDynamicField[] retVal = new org.otrs.ticketconnector.OTRSDynamicField[this.dynamicField.length] ;
        System.arraycopy(this.dynamicField, 0, retVal, 0, this.dynamicField.length);
        return (retVal);
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link org.otrs.ticketconnector.OTRSDynamicField }
     *     
     */
    public org.otrs.ticketconnector.OTRSDynamicField getDynamicField(int idx) {
        if (this.dynamicField == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.dynamicField[idx];
    }

    public int getDynamicFieldLength() {
        if (this.dynamicField == null) {
            return  0;
        }
        return this.dynamicField.length;
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link org.otrs.ticketconnector.OTRSDynamicField }
     *     
     */
    public void setDynamicField(org.otrs.ticketconnector.OTRSDynamicField[] values) {
        int len = values.length;
        this.dynamicField = ((org.otrs.ticketconnector.OTRSDynamicField[]) new org.otrs.ticketconnector.OTRSDynamicField[len] );
        for (int i = 0; (i<len); i ++) {
            this.dynamicField[i] = values[i];
        }
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link org.otrs.ticketconnector.OTRSDynamicField }
     *     
     */
    public org.otrs.ticketconnector.OTRSDynamicField setDynamicField(int idx, org.otrs.ticketconnector.OTRSDynamicField value) {
        return this.dynamicField[idx] = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link org.otrs.ticketconnector.OTRSAttachment }
     *     
     */
    public org.otrs.ticketconnector.OTRSAttachment[] getAttachment() {
        if (this.attachment == null) {
            return new org.otrs.ticketconnector.OTRSAttachment[ 0 ] ;
        }
        org.otrs.ticketconnector.OTRSAttachment[] retVal = new org.otrs.ticketconnector.OTRSAttachment[this.attachment.length] ;
        System.arraycopy(this.attachment, 0, retVal, 0, this.attachment.length);
        return (retVal);
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link org.otrs.ticketconnector.OTRSAttachment }
     *     
     */
    public org.otrs.ticketconnector.OTRSAttachment getAttachment(int idx) {
        if (this.attachment == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.attachment[idx];
    }

    public int getAttachmentLength() {
        if (this.attachment == null) {
            return  0;
        }
        return this.attachment.length;
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link org.otrs.ticketconnector.OTRSAttachment }
     *     
     */
    public void setAttachment(org.otrs.ticketconnector.OTRSAttachment[] values) {
        int len = values.length;
        this.attachment = ((org.otrs.ticketconnector.OTRSAttachment[]) new org.otrs.ticketconnector.OTRSAttachment[len] );
        for (int i = 0; (i<len); i ++) {
            this.attachment[i] = values[i];
        }
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link org.otrs.ticketconnector.OTRSAttachment }
     *     
     */
    public org.otrs.ticketconnector.OTRSAttachment setAttachment(int idx, org.otrs.ticketconnector.OTRSAttachment value) {
        return this.attachment[idx] = value;
    }

}
