/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.otrs31;

import java.math.BigInteger;
import java.util.Objects;
import javax.xml.ws.BindingProvider;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.ticketer.otrs.common.DefaultOtrsConfigDao;
import org.opennms.netmgt.ticketer.otrs31.Otrs31PluginException;
import org.otrs.ticketconnector.GenericTicketConnector;
import org.otrs.ticketconnector.GenericTicketConnectorInterface;
import org.otrs.ticketconnector.OTRSArticle;
import org.otrs.ticketconnector.OTRSTicketCreate;
import org.otrs.ticketconnector.OTRSTicketCreateResponse;
import org.otrs.ticketconnector.OTRSTicketCreateTicket;
import org.otrs.ticketconnector.OTRSTicketGet;
import org.otrs.ticketconnector.OTRSTicketGetResponse;
import org.otrs.ticketconnector.OTRSTicketGetResponseArticle;
import org.otrs.ticketconnector.OTRSTicketGetResponseTicket;
import org.otrs.ticketconnector.OTRSTicketUpdate;
import org.otrs.ticketconnector.OTRSTicketUpdateTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Otrs31TicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(Otrs31TicketerPlugin.class);
    private final DefaultOtrsConfigDao m_configDao = new DefaultOtrsConfigDao();
    private final GenericTicketConnectorInterface m_ticketConnector = new GenericTicketConnector().getGenericTicketConnectorEndPoint();

    public Otrs31TicketerPlugin() {
        BindingProvider bindingProvider = (BindingProvider)this.m_ticketConnector;
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.m_configDao.getEndpoint());
        LOG.info("Binding {} to value {}", (Object)"javax.xml.ws.service.endpoint.address", (Object)this.m_configDao.getEndpoint());
    }

    public Ticket get(String ticketId) throws PluginException {
        Objects.requireNonNull(ticketId, "Please provide a ticketId");
        Objects.requireNonNull(this.m_ticketConnector, "The GenericTicketConnector was not initialized properly");
        OTRSTicketGet ticketGet = new OTRSTicketGet();
        ticketGet.setUserLogin(this.m_configDao.getUserName());
        ticketGet.setPassword(this.m_configDao.getPassword());
        ticketGet.setTicketID(new BigInteger[]{new BigInteger(ticketId)});
        OTRSTicketGetResponse response = this.m_ticketConnector.ticketGet(ticketGet);
        LOG.debug("TicketGet responded with {} tickets" + response.getTicketLength());
        if (response.getTicketLength() == 0) {
            // empty if block
        }
        if (response.getTicketLength() > 1) {
            LOG.warn("Received more than 1 tickets, ignore all except the first one.");
        }
        OTRSTicketGetResponseTicket otrsTicket = response.getTicket(0);
        Ticket opennmsTicket = new Ticket();
        opennmsTicket.setId(otrsTicket.getTicketID().toString());
        opennmsTicket.setSummary(otrsTicket.getTitle());
        opennmsTicket.setUser(otrsTicket.getCustomerUserID());
        opennmsTicket.setState(this.otrsToOpenNMSState(otrsTicket.getStateID()));
        String opennmsTicketDetails = "";
        for (OTRSTicketGetResponseArticle article : otrsTicket.getArticle()) {
            LOG.debug("Adding Article details from OTRS article ID {}", (Object)article.getArticleID());
            opennmsTicketDetails = opennmsTicketDetails + "\n" + "From: " + article.getFrom() + "\n" + "Subject: " + article.getSubject() + "\n" + "Body: " + article.getBody() + "\n";
        }
        opennmsTicket.setDetails(opennmsTicketDetails);
        return opennmsTicket;
    }

    public void saveOrUpdate(Ticket ticketToUpdateOrCreate) throws PluginException {
        Objects.requireNonNull(ticketToUpdateOrCreate, "The provided ticket must not be null");
        if (ticketToUpdateOrCreate.getId() == null) {
            this.create(ticketToUpdateOrCreate);
        } else {
            this.update(ticketToUpdateOrCreate);
        }
    }

    private void create(Ticket newTicket) throws Otrs31PluginException {
        String summary = newTicket.getSummary().replaceAll("\\<.*?\\>", "");
        OTRSTicketCreateTicket otrsTicket = new OTRSTicketCreateTicket();
        otrsTicket.setCustomerUser(this.m_configDao.getDefaultUser());
        otrsTicket.setTitle(summary);
        otrsTicket.setQueue(this.m_configDao.getQueue());
        otrsTicket.setStateID(this.openNMSToOTRSState(newTicket.getState()));
        otrsTicket.setPriority(this.m_configDao.getPriority());
        OTRSArticle otrsArticle = new OTRSArticle();
        otrsArticle.setSubject(summary);
        otrsArticle.setBody(newTicket.getDetails());
        otrsArticle.setArticleType(this.m_configDao.getArticleType());
        otrsArticle.setSenderType(this.m_configDao.getArticleSenderType());
        otrsArticle.setContentType(this.m_configDao.getArticleContentType());
        otrsArticle.setHistoryType(this.m_configDao.getArticleHistoryType());
        otrsArticle.setHistoryComment(this.m_configDao.getArticleHistoryComment());
        OTRSTicketCreate createRequest = new OTRSTicketCreate();
        createRequest.setUserLogin(this.m_configDao.getUserName());
        createRequest.setPassword(this.m_configDao.getPassword());
        createRequest.setTicket(otrsTicket);
        createRequest.setArticle(otrsArticle);
        OTRSTicketCreateResponse response = this.m_ticketConnector.ticketCreate(createRequest);
        if (response.getError() != null) {
            throw new Otrs31PluginException(response.getError());
        }
        LOG.debug("Created new ticket with ID {}", (Object)response.getTicketID().toString());
        newTicket.setId(response.getTicketID().toString());
    }

    private void update(Ticket ticketToUpdate) throws PluginException {
        Ticket currentTicket = this.get(ticketToUpdate.getId());
        LOG.debug("updating existing ticket : {}", (Object)currentTicket.getId());
        if (currentTicket.getState() != ticketToUpdate.getState()) {
            OTRSTicketUpdateTicket ticketUpdate = new OTRSTicketUpdateTicket();
            ticketUpdate.setStateID(this.openNMSToOTRSState(ticketToUpdate.getState()));
            OTRSArticle articleUpdate = new OTRSArticle();
            articleUpdate.setSubject(this.m_configDao.getArticleUpdateSubject());
            articleUpdate.setArticleType(this.m_configDao.getArticleType());
            articleUpdate.setSenderType(this.m_configDao.getArticleSenderType());
            articleUpdate.setContentType(this.m_configDao.getArticleContentType());
            articleUpdate.setHistoryType(this.m_configDao.getArticleHistoryType());
            articleUpdate.setHistoryComment(this.m_configDao.getArticleHistoryComment());
            switch (ticketToUpdate.getState()) {
                case OPEN: {
                    articleUpdate.setBody(this.m_configDao.getTicketOpenedMessage());
                    break;
                }
                case CANCELLED: {
                    articleUpdate.setBody(this.m_configDao.getTicketCancelledMessage());
                    break;
                }
                case CLOSED: {
                    articleUpdate.setBody(this.m_configDao.getTicketClosedMessage());
                    break;
                }
                default: {
                    LOG.debug("No valid OpenNMS state on ticket");
                    articleUpdate.setBody(this.m_configDao.getTicketUpdatedMessage());
                }
            }
            OTRSTicketUpdate update = new OTRSTicketUpdate();
            update.setUserLogin(this.m_configDao.getUserName());
            update.setPassword(this.m_configDao.getPassword());
            update.setTicketID(new BigInteger(currentTicket.getId()));
            update.setTicket(ticketUpdate);
            update.setArticle(articleUpdate);
            this.m_ticketConnector.ticketUpdate(update);
        }
    }

    private Ticket.State otrsToOpenNMSState(BigInteger otrsStateId) {
        Ticket.State openNMSState;
        if (this.m_configDao.getValidOpenStateId().contains(otrsStateId.intValue())) {
            LOG.debug("OTRS state ID {} matched OpenNMS state Open", (Object)otrsStateId);
            openNMSState = Ticket.State.OPEN;
        } else if (this.m_configDao.getValidClosedStateId().contains(otrsStateId.intValue())) {
            LOG.debug("OTRS state ID {} matched OpenNMS state Closed", (Object)otrsStateId);
            openNMSState = Ticket.State.CLOSED;
        } else if (this.m_configDao.getValidCancelledStateId().contains(otrsStateId.intValue())) {
            LOG.debug("OTRS state ID {} matched OpenNMS state Cancelled", (Object)otrsStateId);
            openNMSState = Ticket.State.CANCELLED;
        } else {
            LOG.debug("OTRS state ID {} has no matching OpenNMS state", (Object)otrsStateId);
            openNMSState = Ticket.State.OPEN;
        }
        return openNMSState;
    }

    private BigInteger openNMSToOTRSState(Ticket.State state) {
        BigInteger otrsStateId;
        LOG.debug("getting otrs state from OpenNMS State {}", (Object)state.toString());
        switch (state) {
            case OPEN: {
                otrsStateId = BigInteger.valueOf(this.m_configDao.getOpenStateId().intValue());
                break;
            }
            case CANCELLED: {
                otrsStateId = BigInteger.valueOf(this.m_configDao.getCancelledStateId().intValue());
                break;
            }
            case CLOSED: {
                otrsStateId = BigInteger.valueOf(this.m_configDao.getClosedStateId().intValue());
                break;
            }
            default: {
                LOG.debug("No valid OpenNMS state on ticket");
                otrsStateId = BigInteger.valueOf(this.m_configDao.getOpenStateId().intValue());
            }
        }
        LOG.debug("OpenNMS state was        {}", (Object)state.toString());
        LOG.debug("Setting OTRS state ID to {}", (Object)otrsStateId.toString());
        return otrsStateId;
    }
}

