
package org.otrs.ticketconnector;

import java.io.Serializable;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.ticketer.otrs31.BigIntegerAdapter;


/**
 * <p>Java class for OTRS_TicketGet complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="OTRS_TicketGet"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice&gt;
 *           &lt;element name="UserLogin" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *           &lt;element name="CustomerUserLogin" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *           &lt;element name="SessionID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element name="Password" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="TicketID" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" maxOccurs="unbounded"/&gt;
 *         &lt;element name="DynamicFields" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *         &lt;element name="Extended" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *         &lt;element name="AllArticles" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *         &lt;element name="ArticleSenderType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="ArticleOrder" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="ArticleLimit" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *         &lt;element name="Attachments" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OTRS_TicketGet", propOrder = {
    "userLogin",
    "customerUserLogin",
    "sessionID",
    "password",
    "ticketID",
    "dynamicFields",
    "extended",
    "allArticles",
    "articleSenderType",
    "articleOrder",
    "articleLimit",
    "attachments"
})
public class OTRSTicketGet
    implements Serializable
{

    @XmlElement(name = "UserLogin")
    protected String userLogin;
    @XmlElement(name = "CustomerUserLogin")
    protected String customerUserLogin;
    @XmlElement(name = "SessionID")
    protected String sessionID;
    @XmlElement(name = "Password")
    protected String password;
    @XmlElement(name = "TicketID", required = true, type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger[] ticketID;
    @XmlElement(name = "DynamicFields", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger dynamicFields;
    @XmlElement(name = "Extended", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger extended;
    @XmlElement(name = "AllArticles", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger allArticles;
    @XmlElement(name = "ArticleSenderType")
    protected String articleSenderType;
    @XmlElement(name = "ArticleOrder")
    protected String articleOrder;
    @XmlElement(name = "ArticleLimit", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger articleLimit;
    @XmlElement(name = "Attachments", type = String.class)
    @XmlJavaTypeAdapter(BigIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    protected BigInteger attachments;

    /**
     * Gets the value of the userLogin property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserLogin() {
        return userLogin;
    }

    /**
     * Sets the value of the userLogin property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUserLogin(String value) {
        this.userLogin = value;
    }

    /**
     * Gets the value of the customerUserLogin property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCustomerUserLogin() {
        return customerUserLogin;
    }

    /**
     * Sets the value of the customerUserLogin property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCustomerUserLogin(String value) {
        this.customerUserLogin = value;
    }

    /**
     * Gets the value of the sessionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSessionID() {
        return sessionID;
    }

    /**
     * Sets the value of the sessionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSessionID(String value) {
        this.sessionID = value;
    }

    /**
     * Gets the value of the password property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPassword() {
        return password;
    }

    /**
     * Sets the value of the password property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * 
     * 
     * @return
     *     array of
     *     {@link String }
     *     
     */
    public BigInteger[] getTicketID() {
        if (this.ticketID == null) {
            return new BigInteger[ 0 ] ;
        }
        BigInteger[] retVal = new BigInteger[this.ticketID.length] ;
        System.arraycopy(this.ticketID, 0, retVal, 0, this.ticketID.length);
        return (retVal);
    }

    /**
     * 
     * 
     * @return
     *     one of
     *     {@link String }
     *     
     */
    public BigInteger getTicketID(int idx) {
        if (this.ticketID == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.ticketID[idx];
    }

    public int getTicketIDLength() {
        if (this.ticketID == null) {
            return  0;
        }
        return this.ticketID.length;
    }

    /**
     * 
     * 
     * @param values
     *     allowed objects are
     *     {@link String }
     *     
     */
    public void setTicketID(BigInteger[] values) {
        int len = values.length;
        this.ticketID = ((BigInteger[]) new BigInteger[len] );
        for (int i = 0; (i<len); i ++) {
            this.ticketID[i] = values[i];
        }
    }

    /**
     * 
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public BigInteger setTicketID(int idx, BigInteger value) {
        return this.ticketID[idx] = value;
    }

    /**
     * Gets the value of the dynamicFields property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getDynamicFields() {
        return dynamicFields;
    }

    /**
     * Sets the value of the dynamicFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDynamicFields(BigInteger value) {
        this.dynamicFields = value;
    }

    /**
     * Gets the value of the extended property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getExtended() {
        return extended;
    }

    /**
     * Sets the value of the extended property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExtended(BigInteger value) {
        this.extended = value;
    }

    /**
     * Gets the value of the allArticles property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getAllArticles() {
        return allArticles;
    }

    /**
     * Sets the value of the allArticles property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAllArticles(BigInteger value) {
        this.allArticles = value;
    }

    /**
     * Gets the value of the articleSenderType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getArticleSenderType() {
        return articleSenderType;
    }

    /**
     * Sets the value of the articleSenderType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArticleSenderType(String value) {
        this.articleSenderType = value;
    }

    /**
     * Gets the value of the articleOrder property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getArticleOrder() {
        return articleOrder;
    }

    /**
     * Sets the value of the articleOrder property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArticleOrder(String value) {
        this.articleOrder = value;
    }

    /**
     * Gets the value of the articleLimit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getArticleLimit() {
        return articleLimit;
    }

    /**
     * Sets the value of the articleLimit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArticleLimit(BigInteger value) {
        this.articleLimit = value;
    }

    /**
     * Gets the value of the attachments property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public BigInteger getAttachments() {
        return attachments;
    }

    /**
     * Sets the value of the attachments property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttachments(BigInteger value) {
        this.attachments = value;
    }

}
