/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.protocolcollector.snmp.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.nrtg.api.ProtocolCollector;
import org.opennms.nrtg.api.model.CollectionJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpProtocolCollector
implements ProtocolCollector {
    private static Logger LOG = LoggerFactory.getLogger(SnmpProtocolCollector.class);
    private static final String PROTOCOL = "SNMP";
    private NodeDao m_nodeDao;
    private LocationAwareSnmpClient m_locationAwareSnmpClient;

    private String typeToString(int type) {
        switch (type) {
            case 65: {
                return "counter32";
            }
            case 70: {
                return "counter64";
            }
            case 66: {
                return "gauge32";
            }
            case 2: {
                return "int32";
            }
            case 64: {
                return "ipAddress";
            }
            case 4: {
                return "octetString";
            }
            case 68: {
                return "opaque";
            }
            case 67: {
                return "timeticks";
            }
            case 6: {
                return "objectIdentifier";
            }
            case 5: {
                return "null";
            }
        }
        return "unknown";
    }

    public CollectionJob collect(final CollectionJob collectionJob) {
        OnmsMonitoringLocation monitoringLocation;
        LOG.info("SnmpProtocolCollector is collecting collectionJob '{}'", (Object)collectionJob.getId());
        SnmpAgentConfig snmpAgentConfig = SnmpAgentConfig.parseProtocolConfigurationString((String)collectionJob.getProtocolConfiguration());
        ArrayList<1> trackers = new ArrayList<1>();
        for (final String metricObjId : collectionJob.getAllMetrics()) {
            SnmpObjId requestOid = SnmpObjId.get((String)metricObjId);
            SnmpObjId base = requestOid.getPrefix(requestOid.length() - 1);
            int lastId = requestOid.getLastSubId();
            SingleInstanceTracker instanceTracker = new SingleInstanceTracker(base, new SnmpInstId(lastId)){

                protected void storeResult(SnmpResult result) {
                    LOG.trace("Collected SnmpValue '{}'", (Object)result);
                    SnmpValue value = result.getValue();
                    String metricType = value == null ? "unknown" : SnmpProtocolCollector.this.typeToString(value.getType());
                    collectionJob.setMetricValue(metricObjId, metricType, value == null ? null : value.toDisplayString());
                }

                public void setFailed(boolean failed) {
                    super.setFailed(failed);
                    LOG.trace("Collection Failed for metricObjId '{}'", (Object)metricObjId);
                    collectionJob.setMetricValue(metricObjId, "unknown", null);
                }

                public void setTimedOut(boolean timedOut) {
                    super.setTimedOut(timedOut);
                    LOG.trace("Collection timedOut for metricObjId '{}'", (Object)metricObjId);
                    collectionJob.setMetricValue(metricObjId, "unknown", null);
                }
            };
            trackers.add(instanceTracker);
        }
        String locationName = null;
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(collectionJob.getNodeId()));
        if (node != null && (monitoringLocation = node.getLocation()) != null) {
            locationName = monitoringLocation.getLocationName();
        }
        AggregateTracker tracker = new AggregateTracker(trackers);
        CompletableFuture future = this.m_locationAwareSnmpClient.walk(snmpAgentConfig, (CollectionTracker)tracker).withDescription("NRTG").withLocation(locationName).execute();
        try {
            future.get();
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to collect SNMP metrics for {}.", (Object)snmpAgentConfig.getAddress(), (Object)e);
        }
        catch (InterruptedException e) {
            LOG.warn("Interupted while collectiong SNMP metrics for {}.", (Object)snmpAgentConfig.getAddress());
            Thread.interrupted();
        }
        return collectionJob;
    }

    public String getProtcol() {
        return PROTOCOL;
    }

    public void setLocationAwareSnmpClient(LocationAwareSnmpClient locationAwareSnmpClient) {
        this.m_locationAwareSnmpClient = locationAwareSnmpClient;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

