/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.protocolcollector.snmp.internal;

import java.util.ArrayList;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.nrtg.api.ProtocolCollector;
import org.opennms.nrtg.api.model.CollectionJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpProtocolCollector
implements ProtocolCollector {
    private static Logger logger = LoggerFactory.getLogger(SnmpProtocolCollector.class);
    private static final String PROTOCOL = "SNMP";
    private SnmpStrategy m_snmpStrategy;

    public SnmpStrategy getSnmpStrategy() {
        return this.m_snmpStrategy;
    }

    public void setSnmpStrategy(SnmpStrategy snmpStrategy) {
        this.m_snmpStrategy = snmpStrategy;
    }

    private String typeToString(int type) {
        switch (type) {
            case 65: {
                return "counter32";
            }
            case 70: {
                return "counter64";
            }
            case 66: {
                return "gauge32";
            }
            case 2: {
                return "int32";
            }
            case 64: {
                return "ipAddress";
            }
            case 4: {
                return "octetString";
            }
            case 68: {
                return "opaque";
            }
            case 67: {
                return "timeticks";
            }
            case 6: {
                return "objectIdentifier";
            }
            case 5: {
                return "null";
            }
        }
        return "unknown";
    }

    public CollectionJob collect(final CollectionJob collectionJob) {
        logger.info("SnmpProtocolCollector is collecting collectionJob '{}'", (Object)collectionJob.getId());
        SnmpAgentConfig snmpAgentConfig = SnmpAgentConfig.parseProtocolConfigurationString((String)collectionJob.getProtocolConfiguration());
        ArrayList<1> trackers = new ArrayList<1>();
        for (final String metricObjId : collectionJob.getAllMetrics()) {
            SnmpObjId requestOid = SnmpObjId.get((String)metricObjId);
            SnmpObjId base = requestOid.getPrefix(requestOid.length() - 1);
            int lastId = requestOid.getLastSubId();
            SingleInstanceTracker instanceTracker = new SingleInstanceTracker(base, new SnmpInstId(lastId)){

                protected void storeResult(SnmpResult result) {
                    logger.trace("Collected SnmpValue '{}'", (Object)result);
                    SnmpValue value = result.getValue();
                    String metricType = value == null ? "unknown" : SnmpProtocolCollector.this.typeToString(value.getType());
                    collectionJob.setMetricValue(metricObjId, metricType, value == null ? null : value.toDisplayString());
                }

                public void setFailed(boolean failed) {
                    super.setFailed(failed);
                    logger.trace("Collection Failed for metricObjId '{}'", (Object)metricObjId);
                    collectionJob.setMetricValue(metricObjId, "unknown", null);
                }

                public void setTimedOut(boolean timedOut) {
                    super.setTimedOut(timedOut);
                    logger.trace("Collection timedOut for metricObjId '{}'", (Object)metricObjId);
                    collectionJob.setMetricValue(metricObjId, "unknown", null);
                }
            };
            trackers.add(instanceTracker);
        }
        AggregateTracker tracker = new AggregateTracker(trackers);
        SnmpWalker walker = this.m_snmpStrategy.createWalker(snmpAgentConfig, "SnmpProtocolCollector for " + snmpAgentConfig.getAddress(), (CollectionTracker)tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return collectionJob;
    }

    public String getProtcol() {
        return PROTOCOL;
    }
}

