/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.web.internal;

import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.nrtg.web.internal.ModelAndView;
import org.opennms.nrtg.web.internal.NrtController;

public class NrtServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private NrtController m_controller;

    public void setController(NrtController controller) {
        this.m_controller = controller;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession httpSession = req.getSession(true);
        resp.setContentType("text/html");
        if (req.getParameter("nrtCollectionTaskId") != null) {
            this.m_controller.nrtCollectionJobTrigger(req.getParameter("nrtCollectionTaskId"), httpSession);
            if ("true".equals(req.getParameter("poll"))) {
                resp.getOutputStream().println(this.m_controller.getMeasurementSetsForDestination(req.getParameter("nrtCollectionTaskId")));
            }
        } else if (req.getParameter("resourceId") != null && req.getParameter("report") != null) {
            boolean useJson;
            boolean bl = useJson = req.getHeader("Accept") != null && req.getHeader("Accept").contains("application/json");
            if (useJson) {
                resp.setContentType(MediaType.JSON_UTF_8.toString());
            }
            ModelAndView modelAndView = this.m_controller.nrtStart(req.getParameter("resourceId"), req.getParameter("report"), httpSession, useJson);
            String template = this.getTemplateAsString(modelAndView.getViewName() + ".template");
            for (Map.Entry<String, Object> entry : modelAndView.getModel().entrySet()) {
                template = template.replaceAll("\\$\\{" + entry.getKey() + "\\}", entry.getValue() != null ? entry.getValue().toString() : "null");
            }
            resp.getOutputStream().write(template.getBytes());
        } else {
            throw new ServletException("unrecognized servlet parameters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplateAsString(String templateName) throws IOException {
        try (BufferedReader r = null;){
            String line;
            StringBuilder results = new StringBuilder();
            r = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/" + templateName)));
            while ((line = r.readLine()) != null) {
                results.append(line).append('\n');
            }
            String string = results.toString();
            return string;
        }
    }
}

