/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.web.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.nrtg.api.NrtBroker;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.DefaultCollectionJob;
import org.opennms.nrtg.api.model.MeasurementSet;
import org.opennms.nrtg.web.internal.ModelAndView;
import org.opennms.nrtg.web.internal.NrtHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NrtController {
    private static Logger logger = LoggerFactory.getLogger(NrtController.class);
    private GraphDao m_graphDao;
    private NodeDao m_nodeDao;
    private ResourceDao m_resourceDao;
    private ResourceStorageDao m_resourceStorageDao;
    private SnmpAgentConfigFactory m_snmpAgentConfigFactory;
    private NrtBroker m_nrtBroker;
    private static final String PROTOCOLDELIMITER = "_";
    private static final String METRICID_DELIMITER = "=";

    public ModelAndView nrtStart(String resourceId, String report, HttpSession httpSession, boolean useJson) {
        assert (resourceId != null);
        logger.debug("resourceId: '{}'", (Object)resourceId);
        assert (report != null);
        logger.debug("report: '{}'", (Object)report);
        OnmsResource reportResource = this.m_resourceDao.getResourceById(resourceId);
        PrefabGraph prefabGraph = this.m_graphDao.getPrefabGraph(report);
        String nrtCollectionTaskId = String.format("NrtCollectionTaskId_%d_%d", System.currentTimeMillis(), new Random().nextInt());
        List<CollectionJob> collectionJobs = this.createCollectionJobs(reportResource, prefabGraph, nrtCollectionTaskId);
        for (CollectionJob collectionJob : collectionJobs) {
            this.m_nrtBroker.publishCollectionJob(collectionJob);
            this.getCollectionJobMap(httpSession, true).put(nrtCollectionTaskId, collectionJob);
        }
        String viewName = useJson ? "nrt/realtime.json" : "nrt/realtime.html";
        ModelAndView modelAndView = new ModelAndView(viewName);
        modelAndView.addObject("nrtCollectionTaskId", nrtCollectionTaskId);
        modelAndView.addObject("graphTitle", prefabGraph.getTitle());
        modelAndView.addObject("graphName", prefabGraph.getName());
        modelAndView.addObject("graphDescription", prefabGraph.getDescription());
        NrtHelper nrtHelper = new NrtHelper();
        modelAndView.addObject("rrdGraphString", nrtHelper.cleanUpRrdGraphStringForWebUi(prefabGraph, this.getRequiredExternalPropertyAttributes(reportResource, prefabGraph), this.getRequiredStringPropertyAttributes(reportResource, prefabGraph)));
        Set<RrdGraphAttribute> relevantRrdGraphAttributes = this.getRequiredRrdGraphAttributes(reportResource, prefabGraph);
        Map<String, String> rrdGraphAttributesMetaData = this.getMetaDataForReport(relevantRrdGraphAttributes);
        Map<String, String> rrdGraphAttributesToMetricIds = this.getRrdGraphAttributesToMetricIds(rrdGraphAttributesMetaData);
        modelAndView.addObject("metricsMapping", nrtHelper.generateJsMappingObject(prefabGraph.getCommand(), rrdGraphAttributesToMetricIds));
        return modelAndView;
    }

    public void nrtCollectionJobTrigger(String nrtCollectionTaskId, HttpSession httpSession) {
        logger.debug("Republish CollectionJobTrigger for '{}'", (Object)nrtCollectionTaskId);
        Map<String, CollectionJob> nrtCollectionTasks = this.getCollectionJobMap(httpSession, false);
        if (nrtCollectionTasks != null) {
            CollectionJob collectionJob = nrtCollectionTasks.get(nrtCollectionTaskId);
            logger.debug("CollectionJob is '{}'", (Object)collectionJob);
            if (collectionJob != null) {
                this.m_nrtBroker.publishCollectionJob(collectionJob);
                logger.debug("collectionJob was sent!");
            } else {
                logger.debug("collectionJob for collectionTask not found in session '{}'", (Object)nrtCollectionTaskId);
            }
        } else {
            logger.debug("No CollectionTasks map in session found.");
        }
    }

    public String getMeasurementSetsForDestination(String nrtCollectionTaskId) {
        List measurementSets = this.m_nrtBroker.receiveMeasurementSets(nrtCollectionTaskId);
        StringBuffer buffer = new StringBuffer();
        for (MeasurementSet measurementSet : measurementSets) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(measurementSet.toString());
        }
        return "{\"measurement_sets\":[" + buffer.toString() + "]}";
    }

    private Map<String, CollectionJob> getCollectionJobMap(HttpSession httpSession, boolean create) {
        if (create && httpSession.getAttribute("NrtCollectionTasks") == null) {
            httpSession.setAttribute("NrtCollectionTasks", new HashMap());
        }
        try {
            return (Map)httpSession.getAttribute("NrtCollectionTasks");
        }
        catch (Exception e) {
            logger.error("Session contains incompatible datastructure for NrtCollectionTasks attribute '{}'", (Throwable)e);
            return null;
        }
    }

    private List<CollectionJob> createCollectionJobs(OnmsResource reportResource, PrefabGraph prefabGraph, String nrtCollectionTaskId) {
        ArrayList<CollectionJob> collectionJobs = new ArrayList<CollectionJob>();
        OnmsResource nodeResource = reportResource.getParent();
        OnmsNode node = this.m_nodeDao.get(nodeResource.getName());
        Integer nodeId = node.getId();
        Date createTimestamp = new Date();
        Set<RrdGraphAttribute> relevantRrdGraphAttributes = this.getRequiredRrdGraphAttributes(reportResource, prefabGraph);
        Map<String, String> rrdGraphAttributesMetaData = this.getMetaDataForReport(relevantRrdGraphAttributes);
        Map<String, List<MetricTuple>> metricsByProtocol = this.getMetricIdsByProtocol(rrdGraphAttributesMetaData);
        HashSet<String> resultDestinations = new HashSet<String>();
        resultDestinations.add(nrtCollectionTaskId);
        for (Map.Entry<String, List<MetricTuple>> entry : metricsByProtocol.entrySet()) {
            String protocol = entry.getKey();
            List<MetricTuple> tuples = entry.getValue();
            DefaultCollectionJob collectionJob = new DefaultCollectionJob();
            collectionJob.setService(protocol);
            collectionJob.setNodeId(nodeId.intValue());
            collectionJob.setCreationTimestamp(createTimestamp);
            for (MetricTuple metricTuple : tuples) {
                collectionJob.addMetric(metricTuple.getMetricId(), resultDestinations, metricTuple.getOnmsLogicMetricId());
            }
            if (protocol.equals("SNMP") || protocol.equals("TCA")) {
                collectionJob.setNetInterface(protocol);
                SnmpAgentConfig snmpAgentConfig = this.m_snmpAgentConfigFactory.getAgentConfig(node.getPrimaryInterface().getIpAddress());
                collectionJob.setProtocolConfiguration(snmpAgentConfig.toProtocolConfigString());
                collectionJob.setNetInterface(node.getPrimaryInterface().getIpAddress().getHostAddress());
                collectionJobs.add((CollectionJob)collectionJob);
                continue;
            }
            logger.error("Protocol '{}' is not supported yet. CollectionJob will be ignorred.", (Object)protocol);
        }
        return collectionJobs;
    }

    public Set<RrdGraphAttribute> getRequiredRrdGraphAttributes(OnmsResource reportResource, PrefabGraph prefabGraph) {
        Map available = reportResource.getRrdGraphAttributes();
        LinkedHashSet<RrdGraphAttribute> reqAttrs = new LinkedHashSet<RrdGraphAttribute>();
        for (String attrName : prefabGraph.getColumns()) {
            RrdGraphAttribute attr = (RrdGraphAttribute)available.get(attrName);
            if (attr == null) continue;
            reqAttrs.add(attr);
        }
        return reqAttrs;
    }

    public Map<String, String> getRequiredExternalPropertyAttributes(OnmsResource reportResource, PrefabGraph prefabGraph) {
        Map attributes = reportResource.getExternalValueAttributes();
        if (attributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> reqAttributes = new HashMap<String, String>();
        for (String attrName : prefabGraph.getExternalValues()) {
            if (!attributes.containsKey(attrName)) continue;
            reqAttributes.put(attrName, (String)attributes.get(attrName));
        }
        return reqAttributes;
    }

    public Map<String, String> getRequiredStringPropertyAttributes(OnmsResource reportResource, PrefabGraph prefabGraph) {
        Map attributes = reportResource.getStringPropertyAttributes();
        if (attributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> reqAttributes = new HashMap<String, String>();
        for (String attrName : prefabGraph.getPropertiesValues()) {
            if (!attributes.containsKey(attrName)) continue;
            reqAttributes.put(attrName, (String)attributes.get(attrName));
        }
        return reqAttributes;
    }

    private Map<String, String> getRrdGraphAttributesToMetricIds(Map<String, String> onmsResourceNamesToMetaDataLines) {
        HashMap<String, String> rrdGraphAttributesToMetricIds = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : onmsResourceNamesToMetaDataLines.entrySet()) {
            String onmsResouceName = entry.getKey();
            String value = entry.getValue();
            String rrdGraphAttributeName = onmsResouceName.substring(onmsResouceName.lastIndexOf(46) + 1);
            rrdGraphAttributesToMetricIds.put(rrdGraphAttributeName, this.getMetricIdFromMetaDataLine(value));
        }
        return rrdGraphAttributesToMetricIds;
    }

    private Map<String, String> getMetaDataForReport(Set<RrdGraphAttribute> rrdGraphAttributes) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        logger.debug("getMetaDataForReport: " + rrdGraphAttributes);
        for (RrdGraphAttribute attr : rrdGraphAttributes) {
            ResourcePath pathToMetaFile;
            Set metaDataEntrySet;
            String[] knownExtensions = new String[]{".rrd", ".jrb"};
            String metaFileNameWithoutExtension = attr.getRrdFile();
            for (String ext : knownExtensions) {
                if (!metaFileNameWithoutExtension.endsWith(ext)) continue;
                metaFileNameWithoutExtension = metaFileNameWithoutExtension.substring(0, metaFileNameWithoutExtension.lastIndexOf(ext));
                break;
            }
            if ((metaDataEntrySet = this.m_resourceStorageDao.getMetaData(pathToMetaFile = ResourcePath.get((ResourcePath)attr.getResource().getPath(), (String[])new String[]{metaFileNameWithoutExtension})).entrySet()) == null) continue;
            String attrName = attr.getName();
            String attrString = attr.toString();
            for (Map.Entry entry : metaDataEntrySet) {
                String line = (String)entry.getKey() + '=' + (String)entry.getValue();
                if (!line.endsWith(attrName)) continue;
                metaData.put(attrString, line);
            }
        }
        return metaData;
    }

    private String getProtocolFromMetaDataLine(String metaDataLine) {
        return metaDataLine.substring(0, metaDataLine.indexOf(PROTOCOLDELIMITER));
    }

    private String getMetricIdFromMetaDataLine(String metaDataLine) {
        return metaDataLine.substring(metaDataLine.indexOf(PROTOCOLDELIMITER) + 1, metaDataLine.lastIndexOf(METRICID_DELIMITER));
    }

    protected Map<String, List<MetricTuple>> getMetricIdsByProtocol(Map<String, String> rrdGraphAttributesMetaData) {
        HashMap<String, List<MetricTuple>> metricIdsByProtocol = new HashMap<String, List<MetricTuple>>();
        for (Map.Entry<String, String> entry : rrdGraphAttributesMetaData.entrySet()) {
            String protocol = this.getProtocolFromMetaDataLine(entry.getValue());
            String metricId = this.getMetricIdFromMetaDataLine(entry.getValue());
            if (!metricIdsByProtocol.containsKey(protocol)) {
                metricIdsByProtocol.put(protocol, new ArrayList());
            }
            ((List)metricIdsByProtocol.get(protocol)).add(new MetricTuple(metricId, entry.getKey()));
        }
        return metricIdsByProtocol;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setSnmpAgentConfigFactory(SnmpAgentConfigFactory snmpAgentConfigFactory) {
        this.m_snmpAgentConfigFactory = snmpAgentConfigFactory;
    }

    public NrtBroker getNrtBroker() {
        return this.m_nrtBroker;
    }

    public void setNrtBroker(NrtBroker nrtBroker) {
        this.m_nrtBroker = nrtBroker;
    }

    public ResourceStorageDao getResourceStorageDao() {
        return this.m_resourceStorageDao;
    }

    public void setResourceStorageDao(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
    }

    protected static class MetricTuple {
        private String m_metricId;
        private String m_onmsLogicMetricId;

        public MetricTuple(String metricId, String onmsLogicMetricId) {
            this.m_onmsLogicMetricId = onmsLogicMetricId;
            this.m_metricId = metricId;
        }

        public String getMetricId() {
            return this.m_metricId;
        }

        public String getOnmsLogicMetricId() {
            return this.m_onmsLogicMetricId;
        }

        public boolean equals(Object object) {
            if (object instanceof MetricTuple) {
                return this.getOnmsLogicMetricId().equals(((MetricTuple)object).getOnmsLogicMetricId());
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.m_metricId != null ? this.m_metricId.hashCode() : 0);
            return hash;
        }
    }
}

