/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.nrtbroker.local.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.nrtg.api.NrtBroker;
import org.opennms.nrtg.api.ProtocolCollector;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.MeasurementSet;
import org.opennms.nrtg.nrtbroker.local.internal.NrtBrokerLocalMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NrtBrokerLocal
implements NrtBroker,
NrtBrokerLocalMBean {
    private static Logger logger = LoggerFactory.getLogger((String)("OpenNMS.WEB." + NrtBrokerLocal.class));
    private List<ProtocolCollector> m_protocolCollectors;
    private TimedOutMap m_measurementSets = new TimedOutMap();

    public void publishCollectionJob(CollectionJob collectionJob) {
        ProtocolCollector protocolCollector = this.getProtocolCollector(collectionJob.getService());
        if (protocolCollector != null) {
            collectionJob = protocolCollector.collect(collectionJob);
            collectionJob.setFinishedTimestamp(new Date());
            this.m_measurementSets.addMeasurementSets(collectionJob.getMeasurementSetsByDestination());
        } else {
            logger.warn("Cannot find collector for protocol {}", (Object)collectionJob.getService());
        }
    }

    public List<MeasurementSet> receiveMeasurementSets(String destination) {
        return this.m_measurementSets.getAndRemove(destination);
    }

    public ProtocolCollector getProtocolCollector(String protocol) {
        for (ProtocolCollector protocolCollector : this.m_protocolCollectors) {
            if (!protocolCollector.getProtcol().equals(protocol)) continue;
            return protocolCollector;
        }
        return null;
    }

    public void setProtocolCollectors(List<ProtocolCollector> protocolCollectors) {
        this.m_protocolCollectors = protocolCollectors;
    }

    public List<ProtocolCollector> getProtocolCollectors() {
        return this.m_protocolCollectors;
    }

    @Override
    public Integer getMeasurementSetSize() {
        return this.m_measurementSets.getAmountOfMeasurementSets();
    }

    private class TimedOutMap {
        private Map<String, List<MeasurementSet>> m_measurementSets = new HashMap<String, List<MeasurementSet>>();
        private Map<String, Date> m_lastAccess = new HashMap<String, Date>();

        private TimedOutMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<MeasurementSet> getAndRemove(String key) {
            Map<String, List<MeasurementSet>> map = this.m_measurementSets;
            synchronized (map) {
                this.m_lastAccess.put(key, new Date());
                List<MeasurementSet> measurementSetList = this.m_measurementSets.get(key);
                this.m_measurementSets.put(key, new ArrayList());
                return measurementSetList;
            }
        }

        public void addMeasurementSets(Map<String, MeasurementSet> measurementSets) {
            for (Map.Entry<String, MeasurementSet> entry : measurementSets.entrySet()) {
                String[] arr;
                for (String destination : arr = entry.getKey().split(",")) {
                    this.addMeasurementSet(destination.trim(), entry.getValue());
                }
            }
            this.doHousekeeping();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMeasurementSet(String key, MeasurementSet measurementSet) {
            Map<String, List<MeasurementSet>> map = this.m_measurementSets;
            synchronized (map) {
                if (!this.m_measurementSets.containsKey(key)) {
                    this.m_measurementSets.put(key, new ArrayList());
                }
                List<MeasurementSet> measurementSetList = this.m_measurementSets.get(key);
                measurementSetList.add(measurementSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHousekeeping() {
            Map<String, List<MeasurementSet>> map = this.m_measurementSets;
            synchronized (map) {
                for (String key : this.m_lastAccess.keySet()) {
                    Date lastAccess = this.m_lastAccess.get(key);
                    Date now = new Date();
                    if (now.getTime() - lastAccess.getTime() <= 120000L) continue;
                    this.m_lastAccess.remove(key);
                    this.m_measurementSets.remove(key);
                    logger.warn("Timed out object removed '{}'", (Object)key);
                }
            }
        }

        private Integer getAmountOfMeasurementSets() {
            return this.m_measurementSets.size();
        }
    }
}

