/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.commander.internal;

import org.opennms.nrtg.api.model.CollectionTask;
import org.opennms.nrtg.commander.internal.PooledJobPublisher;
import org.opennms.nrtg.commander.internal.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class CollectionCommanderStarter {
    private static final Logger logger = LoggerFactory.getLogger(CollectionCommanderStarter.class);
    private static AbstractApplicationContext context;

    public static void main(String[] args) {
        context = new AnnotationConfigApplicationContext(new Class[]{AppConfig.class});
        context.registerShutdownHook();
        new CollectionCommanderStarter().start();
        context.close();
    }

    public void start() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(4);
        taskExecutor.initialize();
        taskExecutor.setMaxPoolSize(4);
        taskExecutor.setQueueCapacity(8);
        taskExecutor.initialize();
        Long startTime = System.currentTimeMillis();
        Integer i = 0;
        while (i < 100) {
            CollectionTask ct = new CollectionTask(Integer.valueOf(1200), "SNMP_All_Metrics");
            PooledJobPublisher jobPublisher = new PooledJobPublisher(ct);
            taskExecutor.execute((Runnable)jobPublisher);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        logger.info("All started '{}'ms", (Object)(System.currentTimeMillis() - startTime));
        Boolean done = false;
        while (!done.booleanValue()) {
            if (taskExecutor.getActiveCount() == 0) {
                logger.info("Tasks active '{}'", (Object)taskExecutor.getActiveCount());
                logger.info("All done '{}'ms", (Object)(System.currentTimeMillis() - startTime));
                taskExecutor.shutdown();
                done = true;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("'{}'", (Object)e.getMessage());
            }
        }
    }

    public static AbstractApplicationContext getContext() {
        return context;
    }
}

