/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.commander.internal.config;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.opennms.nrtg.commander.internal.JmsExceptionListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

@Configuration
public class AppConfig {
    @Bean(name={"connectionFactory"})
    public CachingConnectionFactory connectionFactory() {
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory();
        cachingConnectionFactory.setTargetConnectionFactory(this.amqConnectionFactory());
        cachingConnectionFactory.setSessionCacheSize(8);
        cachingConnectionFactory.setExceptionListener((ExceptionListener)this.jmsExceptionListener());
        return cachingConnectionFactory;
    }

    @Bean(name={"amqConnectionFactory"})
    public ConnectionFactory amqConnectionFactory() {
        return new ActiveMQConnectionFactory("failover://tcp://localhost:61616");
    }

    @Bean(name={"JmsTemplate"})
    public JmsTemplate jmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)this.connectionFactory());
        jmsTemplate.setDeliveryPersistent(false);
        jmsTemplate.setDeliveryMode(1);
        jmsTemplate.setExplicitQosEnabled(true);
        jmsTemplate.setTimeToLive(120000L);
        return jmsTemplate;
    }

    @Bean(name={"JmsExceptionListener"})
    public JmsExceptionListener jmsExceptionListener() {
        return new JmsExceptionListener();
    }
}

